package com.suncode.pwfl.workflow.process.map.builder.function;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.suncode.pwfl.prompting.LlmException;

import java.util.List;

public record FunctionCallArgumentType(Type type, Type subType, List<String> enumValues)
{
    public FunctionCallArgumentType( Type type )
    {
        this( type, null, null );
    }

    public FunctionCallArgumentType( Type type, Type subType )
    {
        this( type, subType, null );
    }

    public FunctionCallArgumentType( Type type, Type subType, List<String> enumValues )
    {
        this.type = type;
        this.subType = subType;
        this.enumValues = enumValues;

        if ( type == Type.ARRAY && subType == null )
        {
            throw new LlmException( "Subtype must be defined for array" );
        }

        if ( (type == Type.ENUM || subType == Type.ENUM) && (enumValues == null || enumValues.isEmpty()) )
        {
            throw new LlmException( "Enum values must be defined for enum type" );
        }
    }

    public enum Type
    {
        STRING, ENUM, NUMBER, INTEGER, BOOLEAN, ARRAY;

        @JsonCreator
        public static Type fromJson( String value )
        {
            return Type.valueOf( value.toUpperCase() );
        }
    }
}
