package com.suncode.pwfl.workflow.process.map;

import lombok.Getter;
import lombok.NonNull;

import java.util.ArrayList;
import java.util.List;

@Getter
public class Process
{

    private String id;

    private String name;

    private final List<Variable> variables = new ArrayList<>();

    private final List<Activity> activities = new ArrayList<>();

    private final List<Transition> transitions = new ArrayList<>();

    public Process()
    {
    }

    public Process( String id, String name )
    {
        setId( id );
        setName( name );
    }

    public void setId( @NonNull String id )
    {
        this.id = id.intern();
    }

    public void setName( @NonNull String name )
    {
        this.name = name.intern();
    }

}
