package com.suncode.pwfl.workflow.process.map;

import lombok.Getter;
import lombok.NonNull;

@Getter
public class Button
{

    private String actionName;

    private String buttonName;

    private String transitionId;

    public Button( String actionName, String buttonName )
    {
        this(actionName, buttonName, null);
    }

    public Button( String actionName, String buttonName, String transitionId )
    {
        setActionName( actionName );
        setButtonName( buttonName );
        setTransitionId( transitionId );
    }

    public void setActionName( @NonNull String actionName )
    {
        this.actionName = actionName.intern();
    }

    public void setButtonName( @NonNull String buttonName )
    {
        this.buttonName = buttonName.intern();
    }

    public void setTransitionId( String transitionId )
    {
        this.transitionId = transitionId != null ? transitionId.intern() : null;
    }

}
