/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.xpdl.builder;

import com.suncode.pwfl.xpdl.builder.XpdlBaseBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlFirstLineDirection;
import com.suncode.pwfl.xpdl.builder.XpdlLinePathBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlTransitionStyle;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class XpdlTransitionBuilder
extends XpdlBaseBuilder {
    private final String id;
    private final String fromActivityId;
    private final String toActivityId;
    private XpdlTransitionStyle transitionStyle = XpdlTransitionStyle.NO_ROUTING_SPLINE;
    private XpdlFirstLineDirection firstLineDirection = XpdlFirstLineDirection.RIGHT;
    private List<XpdlLinePathBuilder> linePaths = new ArrayList<XpdlLinePathBuilder>();

    private XpdlTransitionBuilder(String id, String fromActivityId, String toActivityId) {
        this.id = id;
        this.fromActivityId = fromActivityId;
        this.toActivityId = toActivityId;
    }

    public static XpdlTransitionBuilder create(String id, String fromActivityId, String toActivityId) {
        return new XpdlTransitionBuilder(id, fromActivityId, toActivityId);
    }

    public XpdlTransitionBuilder withTransitionStyle(XpdlTransitionStyle transitionStyle) {
        this.transitionStyle = transitionStyle;
        return this;
    }

    public XpdlTransitionBuilder withFirstLineDirection(XpdlFirstLineDirection firstLineDirection) {
        this.firstLineDirection = firstLineDirection;
        return this;
    }

    public XpdlTransitionBuilder addLinePath(XpdlLinePathBuilder linePath) {
        this.linePaths.add(linePath);
        return this;
    }

    public XpdlTransitionBuilder withLinePaths(List<XpdlLinePathBuilder> linePaths) {
        this.linePaths = linePaths;
        return this;
    }

    @Override
    public Element buildElement(Document document) {
        Element transition = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Transition");
        transition.setAttribute("Id", this.id);
        transition.setAttribute("From", this.fromActivityId);
        transition.setAttribute("To", this.toActivityId);
        Element extendedAttributes = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:ExtendedAttributes");
        this.addExtendedAttribute(document, extendedAttributes, "JaWE_GRAPH_TRANSITION_STYLE", this.transitionStyle.getValue());
        this.addExtendedAttribute(document, extendedAttributes, "FIRST_LINE_DIRECTION", this.firstLineDirection.getValue());
        for (XpdlLinePathBuilder linePath : this.linePaths) {
            this.addExtendedAttribute(document, extendedAttributes, "LINE_PATH_DEF", linePath.build());
        }
        transition.appendChild(extendedAttributes);
        return transition;
    }

    public String getId() {
        return this.id;
    }

    public String getFromActivityId() {
        return this.fromActivityId;
    }

    public String getToActivityId() {
        return this.toActivityId;
    }

    public XpdlTransitionStyle getTransitionStyle() {
        return this.transitionStyle;
    }

    public XpdlFirstLineDirection getFirstLineDirection() {
        return this.firstLineDirection;
    }

    public List<XpdlLinePathBuilder> getLinePaths() {
        return this.linePaths;
    }
}

