/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.xpdl.builder;

import com.suncode.pwfl.xpdl.builder.XpdlBaseBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class XpdlParticipantBuilder
extends XpdlBaseBuilder {
    private final String id;
    private final String name;
    private int width = 1500;
    private int height = 150;

    private XpdlParticipantBuilder(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public static XpdlParticipantBuilder create(String id, String name) {
        return new XpdlParticipantBuilder(id, name);
    }

    public XpdlParticipantBuilder withWidth(int width) {
        this.width = width;
        return this;
    }

    public XpdlParticipantBuilder withHeight(int height) {
        this.height = height;
        return this;
    }

    @Override
    public Element buildElement(Document document) {
        Element participant = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Participant");
        participant.setAttribute("Id", this.id);
        participant.setAttribute("Name", this.name);
        Element participantType = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:ParticipantType");
        participantType.setAttribute("Type", "ROLE");
        participant.appendChild(participantType);
        Element extendedAttributes = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:ExtendedAttributes");
        this.addExtendedAttribute(document, extendedAttributes, "WIDTH", String.valueOf(this.width));
        this.addExtendedAttribute(document, extendedAttributes, "HEIGHT", String.valueOf(this.height));
        participant.appendChild(extendedAttributes);
        return participant;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

