package com.suncode.pwfl.xpdl.builder;

import lombok.Getter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Getter
class XpdlActivityVariableBuilder
    extends XpdlBaseBuilder
{
    private final String id;

    private final boolean editable;

    public XpdlActivityVariableBuilder( String id, boolean editable )
    {
        this.id = id;
        this.editable = editable;
    }

    @Override
    public Element buildElement( Document document )
    {
        Element activityVariable = document.createElementNS( XPDL_NAMESPACE, ELEMENT_EXTENDED_ATTRIBUTE );
        activityVariable.setAttribute( ATTR_NAME, this.editable ? EXT_ATTR_VARIABLE_TO_PROCESS_UPDATE : EXT_ATTR_VARIABLE_TO_PROCESS_VIEW );
        activityVariable.setAttribute( ATTR_VALUE, this.id );

        return activityVariable;
    }
} 