package com.suncode.pwfl.workflow.process.map;

import lombok.Getter;
import lombok.NonNull;
import lombok.Setter;

@Getter
public class VariableRef
{

    private String id;

    @Setter
    private boolean visible = true;

    @Setter
    private boolean editable = true;

    @Setter
    @NonNull
    private Integer position;

    public VariableRef( String id )
    {
        setId( id );
    }

    public VariableRef( String id, boolean visible, boolean editable, Integer position  )
    {
        setId( id );
        this.visible = visible;
        this.editable = editable;
        this.position = position;
    }

    public void setId( @NonNull String id )
    {
        this.id = id.intern();
    }

}
