package com.suncode.pwfl.workflow.process.map;

import lombok.Getter;
import lombok.NonNull;

import java.util.ArrayList;
import java.util.List;

@Getter
public class Activity
{

    private String id;

    private String name;

    private TransitionType transitionType;

    private final List<VariableRef> variableRefs = new ArrayList<>();

    private final List<Button> buttons = new ArrayList<>();

    public Activity( String id, String name )
    {
        this( id, name, TransitionType.DIRECT );
    }

    public Activity( String id, String name, TransitionType transitionType )
    {
        setId( id );
        setName( name );
        setTransitionType(  transitionType );
    }

    public void setId( @NonNull String id )
    {
        this.id = id.intern();
    }

    public void setName( @NonNull String name )
    {
        this.name = name.intern();
    }

    public void setTransitionType( @NonNull TransitionType transitionType )
    {
        this.transitionType = transitionType;
    }

}
