/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.xpdl.builder;

import com.suncode.pwfl.xpdl.builder.XpdlBaseBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlProcessBuilder;
import com.suncode.pwfl.xpdl.builder.utils.LineReplacingStringWriter;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class XpdlBuilder
extends XpdlBaseBuilder {
    private static final String INVALID_PACKAGE_TAG_NAMESPACES_ORDER_PREFIX = "<xpdl:Package xmlns:xpdl=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns=\"http://www.wfmc.org/2002/XPDL1.0\"";
    private static final String VALID_PACKAGE_TAG_NAMESPACES_ORDER_PREFIX = "<xpdl:Package xmlns=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xpdl=\"http://www.wfmc.org/2002/XPDL1.0\"";
    private String packageId = "pakietxpdl";
    private String packageName = "PakietXPDL";
    private LocalDateTime created = LocalDateTime.now();
    private String author = "Administrator PlusWorkflow";
    private final List<XpdlProcessBuilder> processes = new ArrayList<XpdlProcessBuilder>();

    public XpdlBuilder withPackageId(String packageId) {
        this.packageId = packageId;
        return this;
    }

    public XpdlBuilder withPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public XpdlBuilder withCreated(LocalDateTime created) {
        this.created = created;
        return this;
    }

    public XpdlBuilder withCreated(String created) {
        this.created = LocalDateTime.parse(created, DATE_TIME_FORMATTER);
        return this;
    }

    public XpdlBuilder withAuthor(String author) {
        this.author = author;
        return this;
    }

    public XpdlBuilder addProcess(XpdlProcessBuilder process) {
        this.processes.add(process);
        return this;
    }

    public XpdlProcessBuilder createProcess(String id, String name) {
        XpdlProcessBuilder process = XpdlProcessBuilder.create(id, name);
        this.processes.add(process);
        return process;
    }

    public XpdlProcessBuilder getFirstProcess() {
        if (this.processes.isEmpty()) {
            throw new IllegalStateException("No processes have been added. At least one process must be created.");
        }
        return this.processes.get(0);
    }

    public String build() {
        if (this.processes.isEmpty()) {
            throw new IllegalStateException("No processes have been added. At least one process must be created.");
        }
        Document document = this.createDocument();
        document.setXmlVersion("1.0");
        document.setXmlStandalone(true);
        Element rootElement = this.buildElement(document);
        document.appendChild(rootElement);
        return this.documentToString(document);
    }

    private Document createDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error creating XML document", e);
        }
    }

    private String documentToString(Document document) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("doctype-public", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            LineReplacingStringWriter stringWriter = new LineReplacingStringWriter();
            StreamResult result = new StreamResult(stringWriter);
            transformer.transform(source, result);
            StringBuffer xpdlBuffer = stringWriter.getBuffer();
            int invalidPackageTagNamespacesOrderPos = xpdlBuffer.indexOf(INVALID_PACKAGE_TAG_NAMESPACES_ORDER_PREFIX);
            if (invalidPackageTagNamespacesOrderPos != -1) {
                xpdlBuffer.replace(invalidPackageTagNamespacesOrderPos, invalidPackageTagNamespacesOrderPos + INVALID_PACKAGE_TAG_NAMESPACES_ORDER_PREFIX.length(), VALID_PACKAGE_TAG_NAMESPACES_ORDER_PREFIX);
            }
            return stringWriter.toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException("Error converting XML document to string", e);
        }
    }

    @Override
    public Element buildElement(Document document) {
        Element packageElement = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Package");
        packageElement.setAttribute("xmlns", "http://www.wfmc.org/2002/XPDL1.0");
        packageElement.setAttribute("xmlns:xpdl", "http://www.wfmc.org/2002/XPDL1.0");
        packageElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        packageElement.setAttribute("Id", this.packageId);
        packageElement.setAttribute("Name", this.packageName);
        packageElement.setAttribute("xsi:schemaLocation", "http://www.wfmc.org/2002/XPDL1.0 http://wfmc.org/standards/docs/TC-1025_schema_10_xpdl.xsd");
        Element packageHeader = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:PackageHeader");
        Element xpdlVersion = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:XPDLVersion");
        xpdlVersion.setTextContent("1.0");
        packageHeader.appendChild(xpdlVersion);
        Element vendor = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Vendor");
        vendor.setTextContent("Suncode");
        packageHeader.appendChild(vendor);
        Element createdElement = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Created");
        createdElement.setTextContent(this.formatDateTime(this.created));
        packageHeader.appendChild(createdElement);
        packageElement.appendChild(packageHeader);
        Element redefinableHeader = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:RedefinableHeader");
        Element authorElement = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Author");
        authorElement.setTextContent(this.author);
        redefinableHeader.appendChild(authorElement);
        packageElement.appendChild(redefinableHeader);
        Element script = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Script");
        script.setAttribute("Type", "text/javascript");
        packageElement.appendChild(script);
        Element workflowProcesses = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:WorkflowProcesses");
        for (XpdlProcessBuilder process : this.processes) {
            workflowProcesses.appendChild(process.buildElement(document));
        }
        packageElement.appendChild(workflowProcesses);
        packageElement.appendChild(this.buildPackageExtendedAttributes(document));
        return packageElement;
    }

    private Element buildPackageExtendedAttributes(Document document) {
        Element extendedAttributes = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:ExtendedAttributes");
        this.addExtendedAttribute(document, extendedAttributes, "JaWE_CONFIGURATION", "default");
        this.addExtendedAttribute(document, extendedAttributes, "EDITING_TOOL", "Plus Workflow Editor");
        this.addExtendedAttribute(document, extendedAttributes, "EDITING_TOOL_VERSION", "2.2");
        this.addExtendedAttribute(document, extendedAttributes, "EVENT_ACTION_ID_COUNTER", "1");
        this.addExtendedAttribute(document, extendedAttributes, "PWE_VERSION", "4.2-SNAPSHOT");
        return extendedAttributes;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public String getAuthor() {
        return this.author;
    }

    public List<XpdlProcessBuilder> getProcesses() {
        return this.processes;
    }
}

