/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.xpdl.builder;

import com.suncode.pwfl.xpdl.builder.XpdlActivityVariableBuilder;
import com.suncode.pwfl.xpdl.builder.XpdlBaseBuilder;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class XpdlActivityBuilder
extends XpdlBaseBuilder {
    private final String id;
    private final String name;
    private final String participantId;
    private final int xOffset;
    private final int yOffset;
    private List<XpdlActivityVariableBuilder> variables = new ArrayList<XpdlActivityVariableBuilder>();

    private XpdlActivityBuilder(String id, String name, String participantId, int xOffset, int yOffset) {
        this.id = id;
        this.name = name;
        this.participantId = participantId;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public static XpdlActivityBuilder create(String id, String name, String participantId, int xOffset, int yOffset) {
        return new XpdlActivityBuilder(id, name, participantId, xOffset, yOffset);
    }

    public XpdlActivityBuilder withVariables(List<XpdlActivityVariableBuilder> variables) {
        this.variables = new ArrayList<XpdlActivityVariableBuilder>(variables);
        return this;
    }

    @Override
    public Element buildElement(Document document) {
        Element activity = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Activity");
        activity.setAttribute("Id", this.id);
        activity.setAttribute("Name", this.name);
        Element implementation = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Implementation");
        Element no = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:No");
        implementation.appendChild(no);
        activity.appendChild(implementation);
        Element performer = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:Performer");
        performer.setTextContent(this.participantId);
        activity.appendChild(performer);
        Element extendedAttributes = document.createElementNS("http://www.wfmc.org/2002/XPDL1.0", "xpdl:ExtendedAttributes");
        this.addExtendedAttribute(document, extendedAttributes, "JaWE_GRAPH_PARTICIPANT_ID", this.participantId);
        this.addExtendedAttribute(document, extendedAttributes, "JaWE_GRAPH_OFFSET", this.xOffset + "," + this.yOffset);
        for (XpdlActivityVariableBuilder variable : this.variables) {
            extendedAttributes.appendChild(variable.buildElement(document));
        }
        this.addExtendedAttribute(document, extendedAttributes, "EVENTS", "{\"FORM\":{},\"VARIABLE\":{},\"GRID\":{},\"DT_BUTTON\":{},\"ACTION_BUTTON\":{},\"ACCEPT_BUTTON\":{}}");
        activity.appendChild(extendedAttributes);
        return activity;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public List<XpdlActivityVariableBuilder> getVariables() {
        return this.variables;
    }
}

