package com.suncode.pwfl.xpdl.builder.utils;

import java.io.StringWriter;

public class LineReplacingStringWriter
    extends StringWriter
{

    @Override
    public void write( int c )
    {
        if ( c == '\n' && getBuffer().charAt( getBuffer().length() - 1 ) == '\r' )
        {
            getBuffer().deleteCharAt( getBuffer().length() - 1 );
        }

        super.write( c );
    }

    @Override
    public void write( char[] cbuf, int off, int len )
    {
        if ( (off < 0) || (off > cbuf.length) || (len < 0) ||
            ((off + len) > cbuf.length) || ((off + len) < 0) )
        {
            throw new IndexOutOfBoundsException();
        }
        else if ( len == 0 )
        {
            return;
        }

        for ( int i = off; i < off + len; i++ )
        {
            write( cbuf[i] );
        }
    }

    @Override
    public void write( String str )
    {
        super.write( str.replace( "\r\n", "\n" ) );
    }

    @Override
    public void write( String str, int off, int len )
    {
        char[] charBuffer = new char[len];
        str.getChars(off, (off + len), charBuffer, 0);

        write(charBuffer, 0, len);
    }

}
