package com.suncode.pwfl.xpdl.builder;

import lombok.Getter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Getter
class XpdlParticipantBuilder
    extends XpdlBaseBuilder
{

    private final String id;

    private final String name;

    private int width = 1500;

    private int height = 150;

    private XpdlParticipantBuilder( String id, String name )
    {
        this.id = id;
        this.name = name;
    }

    public static XpdlParticipantBuilder create( String id, String name )
    {
        return new XpdlParticipantBuilder( id, name );
    }

    public XpdlParticipantBuilder withWidth( int width )
    {
        this.width = width;
        return this;
    }

    public XpdlParticipantBuilder withHeight( int height )
    {
        this.height = height;
        return this;
    }

    @Override
    public Element buildElement( Document document )
    {
        Element participant = document.createElementNS( XPDL_NAMESPACE, ELEMENT_PARTICIPANT );
        participant.setAttribute( ATTR_ID, id );
        participant.setAttribute( ATTR_NAME, name );

        Element participantType = document.createElementNS( XPDL_NAMESPACE, ELEMENT_PARTICIPANT_TYPE );
        participantType.setAttribute( ATTR_TYPE, STRING_TYPE_ROLE );
        participant.appendChild( participantType );

        Element extendedAttributes = document.createElementNS( XPDL_NAMESPACE, ELEMENT_EXTENDED_ATTRIBUTES );

        addExtendedAttribute( document, extendedAttributes, EXT_ATTR_WIDTH, String.valueOf( width ) );
        addExtendedAttribute( document, extendedAttributes, EXT_ATTR_HEIGHT, String.valueOf( height ) );

        participant.appendChild( extendedAttributes );

        return participant;
    }
} 