package com.suncode.pwfl.xpdl.builder;

import lombok.Getter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import java.util.ArrayList;
import java.util.List;

@Getter
class XpdlActivityBuilder
    extends XpdlBaseBuilder
{

    private final String id;

    private final String name;

    private final String participantId;

    private final int xOffset;

    private final int yOffset;

    private List<XpdlActivityVariableBuilder> variables = new ArrayList<>();

    private XpdlActivityBuilder( String id, String name, String participantId, int xOffset, int yOffset )
    {
        this.id = id;
        this.name = name;
        this.participantId = participantId;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public static XpdlActivityBuilder create( String id, String name, String participantId, int xOffset, int yOffset )
    {
        return new XpdlActivityBuilder( id, name, participantId, xOffset, yOffset );
    }

    public XpdlActivityBuilder withVariables( List<XpdlActivityVariableBuilder> variables )
    {
        this.variables = new ArrayList<>( variables );
        return this;
    }

    @Override
    public Element buildElement( Document document )
    {
        Element activity = document.createElementNS( XPDL_NAMESPACE, ELEMENT_ACTIVITY );
        activity.setAttribute( ATTR_ID, id );
        activity.setAttribute( ATTR_NAME, name );

        Element implementation = document.createElementNS( XPDL_NAMESPACE, ELEMENT_IMPLEMENTATION );
        Element no = document.createElementNS( XPDL_NAMESPACE, ELEMENT_NO );
        implementation.appendChild( no );
        activity.appendChild( implementation );

        Element performer = document.createElementNS( XPDL_NAMESPACE, ELEMENT_PERFORMER );
        performer.setTextContent( participantId );
        activity.appendChild( performer );

        Element extendedAttributes = document.createElementNS( XPDL_NAMESPACE, ELEMENT_EXTENDED_ATTRIBUTES );

        addExtendedAttribute( document, extendedAttributes, EXT_ATTR_JAWE_GRAPH_PARTICIPANT_ID, participantId );
        addExtendedAttribute( document, extendedAttributes, EXT_ATTR_JAWE_GRAPH_OFFSET, xOffset + "," + yOffset );

        for ( XpdlActivityVariableBuilder variable : variables )
        {
            extendedAttributes.appendChild( variable.buildElement( document ) );
        }

        addExtendedAttribute( document, extendedAttributes,
                              EXT_ATTR_EVENTS,
                              "{\"FORM\":{},\"VARIABLE\":{},\"GRID\":{},\"DT_BUTTON\":{},\"ACTION_BUTTON\":{},\"ACCEPT_BUTTON\":{}}" );

        activity.appendChild( extendedAttributes );

        return activity;
    }
} 