/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.cache;

import com.github.javaparser.resolution.cache.Cache;
import com.github.javaparser.resolution.cache.CacheStats;
import com.github.javaparser.symbolsolver.cache.DefaultCacheStats;
import java.util.Objects;
import java.util.Optional;

public class GuavaCache<K, V>
implements Cache<K, V> {
    private final com.google.common.cache.Cache<K, V> guavaCache;

    public static <expectedK, expectedV> GuavaCache<expectedK, expectedV> create(com.google.common.cache.Cache<expectedK, expectedV> guavaCache) {
        return new GuavaCache<expectedK, expectedV>(guavaCache);
    }

    public GuavaCache(com.google.common.cache.Cache<K, V> guavaCache) {
        this.guavaCache = Objects.requireNonNull(guavaCache, "The argument GuavaCache can't be null.");
    }

    public void put(K key, V value) {
        this.guavaCache.put(key, value);
    }

    public Optional<V> get(K key) {
        return Optional.ofNullable(this.guavaCache.getIfPresent(key));
    }

    public void remove(K key) {
        this.guavaCache.invalidate(key);
    }

    public void removeAll() {
        this.guavaCache.invalidateAll();
    }

    public boolean contains(K key) {
        return this.get(key).isPresent();
    }

    public long size() {
        return this.guavaCache.size();
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public CacheStats stats() {
        com.google.common.cache.CacheStats stats = this.guavaCache.stats();
        return new DefaultCacheStats(stats.hitCount(), stats.missCount(), stats.loadSuccessCount(), stats.loadExceptionCount(), stats.totalLoadTime(), stats.evictionCount());
    }
}

