/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.RecordDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.PatternExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.resolution.Navigator;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedAnnotationDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedEnumDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodLikeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserAnnotationDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserAnnotationMemberDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserClassDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserConstructorDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserEnumConstantDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserEnumDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserFieldDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserInterfaceDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserMethodDeclaration;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserTypeParameter;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserVariableDeclaration;
import java.util.Optional;

public class JavaSymbolSolver
implements SymbolResolver {
    private TypeSolver typeSolver;

    public JavaSymbolSolver(TypeSolver typeSolver) {
        this.typeSolver = typeSolver;
    }

    public void inject(CompilationUnit destination) {
        destination.setData(Node.SYMBOL_RESOLVER_KEY, (Object)this);
    }

    public <T> T resolveDeclaration(Node node, Class<T> resultClass) {
        SymbolReference<ResolvedMethodDeclaration> result;
        ResolvedAnnotationDeclaration annotationDeclaration;
        ResolvedEnumDeclaration enumDeclaration;
        Object resolved;
        Object resolved2;
        if (node instanceof MethodDeclaration) {
            return resultClass.cast(new JavaParserMethodDeclaration((MethodDeclaration)node, this.typeSolver));
        }
        if (node instanceof ClassOrInterfaceDeclaration && resultClass.isInstance(resolved2 = this.toTypeDeclaration(node))) {
            return resultClass.cast(resolved2);
        }
        if (node instanceof EnumDeclaration && resultClass.isInstance(resolved2 = this.toTypeDeclaration(node))) {
            return resultClass.cast(resolved2);
        }
        if (node instanceof EnumConstantDeclaration && resultClass.isInstance(resolved = (enumDeclaration = ((EnumDeclaration)node.findAncestor(new Class[]{EnumDeclaration.class}).get()).resolve().asEnum()).getEnumConstants().stream().filter(c -> ((JavaParserEnumConstantDeclaration)c).getWrappedNode() == node).findFirst().get())) {
            return resultClass.cast(resolved);
        }
        if (node instanceof ConstructorDeclaration) {
            ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)node;
            TypeDeclaration typeDeclaration = (TypeDeclaration)node.getParentNode().get();
            ResolvedReferenceTypeDeclaration resolvedTypeDeclaration = this.resolveDeclaration((Node)typeDeclaration, ResolvedReferenceTypeDeclaration.class);
            ResolvedConstructorDeclaration resolved3 = resolvedTypeDeclaration.getConstructors().stream().filter(c -> c instanceof JavaParserConstructorDeclaration).filter(c -> ((JavaParserConstructorDeclaration)c).getWrappedNode() == constructorDeclaration).findFirst().orElseThrow(() -> new RuntimeException("This constructor cannot be found in its parent. This seems wrong"));
            if (resultClass.isInstance(resolved3)) {
                return resultClass.cast(resolved3);
            }
        }
        if (node instanceof AnnotationDeclaration && resultClass.isInstance(resolved2 = this.toTypeDeclaration(node))) {
            return resultClass.cast(resolved2);
        }
        if (node instanceof AnnotationMemberDeclaration && resultClass.isInstance(resolved = (annotationDeclaration = ((AnnotationDeclaration)node.findAncestor(new Class[]{AnnotationDeclaration.class}).get()).resolve()).getAnnotationMembers().stream().filter(c -> ((JavaParserAnnotationMemberDeclaration)c).getWrappedNode() == node).findFirst().get())) {
            return resultClass.cast(resolved);
        }
        if (node instanceof FieldDeclaration) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
            if (fieldDeclaration.getVariables().size() != 1) {
                throw new RuntimeException("Cannot resolve a Field Declaration including multiple variable declarators. Resolve the single variable declarators");
            }
            resolved = new JavaParserFieldDeclaration(fieldDeclaration.getVariable(0), this.typeSolver);
            if (resultClass.isInstance(resolved)) {
                return resultClass.cast(resolved);
            }
        }
        if (node instanceof VariableDeclarator) {
            if (node.getParentNode().isPresent() && node.getParentNode().get() instanceof FieldDeclaration) {
                resolved2 = new JavaParserFieldDeclaration((VariableDeclarator)node, this.typeSolver);
            } else if (node.getParentNode().isPresent() && node.getParentNode().get() instanceof VariableDeclarationExpr) {
                resolved2 = new JavaParserVariableDeclaration((VariableDeclarator)node, this.typeSolver);
            } else {
                throw new UnsupportedOperationException("Parent of VariableDeclarator is: " + node.getParentNode());
            }
            if (resultClass.isInstance(resolved2)) {
                return resultClass.cast(resolved2);
            }
        }
        if (node instanceof MethodCallExpr) {
            result = JavaParserFacade.get(this.typeSolver).solve((MethodCallExpr)node);
            if (result.isSolved()) {
                if (resultClass.isInstance(result.getCorrespondingDeclaration())) {
                    return resultClass.cast(result.getCorrespondingDeclaration());
                }
            } else {
                throw new UnsolvedSymbolException("We are unable to find the method declaration corresponding to " + node);
            }
        }
        if (node instanceof ObjectCreationExpr) {
            result = JavaParserFacade.get(this.typeSolver).solve((ObjectCreationExpr)node);
            if (result.isSolved()) {
                if (resultClass.isInstance(result.getCorrespondingDeclaration())) {
                    return resultClass.cast(result.getCorrespondingDeclaration());
                }
            } else {
                throw new UnsolvedSymbolException("We are unable to find the constructor declaration corresponding to " + node);
            }
        }
        if (node instanceof NameExpr) {
            result = JavaParserFacade.get(this.typeSolver).solve((NameExpr)node);
            if (result.isSolved()) {
                if (resultClass.isInstance(result.getCorrespondingDeclaration())) {
                    return resultClass.cast(result.getCorrespondingDeclaration());
                }
            } else {
                throw new UnsolvedSymbolException("We are unable to find the value declaration corresponding to " + node);
            }
        }
        if (node instanceof MethodReferenceExpr) {
            result = JavaParserFacade.get(this.typeSolver).solve((MethodReferenceExpr)node);
            if (result.isSolved()) {
                if (resultClass.isInstance(result.getCorrespondingDeclaration())) {
                    return resultClass.cast(result.getCorrespondingDeclaration());
                }
            } else {
                throw new UnsolvedSymbolException("We are unable to find the method declaration corresponding to " + node);
            }
        }
        if (node instanceof FieldAccessExpr) {
            result = JavaParserFacade.get(this.typeSolver).solve((FieldAccessExpr)node);
            if (result.isSolved()) {
                if (resultClass.isInstance(result.getCorrespondingDeclaration())) {
                    return resultClass.cast(result.getCorrespondingDeclaration());
                }
            } else {
                ResolvedType scopeType;
                if (((FieldAccessExpr)node).getName().getId().equals("length") && (scopeType = ((FieldAccessExpr)node).getScope().calculateResolvedType()).isArray() && resultClass.isInstance(ArrayLengthValueDeclaration.INSTANCE)) {
                    return resultClass.cast(ArrayLengthValueDeclaration.INSTANCE);
                }
                throw new UnsolvedSymbolException("We are unable to find the value declaration corresponding to " + node);
            }
        }
        if (node instanceof ThisExpr) {
            result = JavaParserFacade.get(this.typeSolver).solve((ThisExpr)node);
            if (result.isSolved()) {
                if (resultClass.isInstance(result.getCorrespondingDeclaration())) {
                    return resultClass.cast(result.getCorrespondingDeclaration());
                }
            } else {
                throw new UnsolvedSymbolException("We are unable to find the type declaration corresponding to " + node);
            }
        }
        if (node instanceof ExplicitConstructorInvocationStmt) {
            result = JavaParserFacade.get(this.typeSolver).solve((ExplicitConstructorInvocationStmt)node);
            if (result.isSolved()) {
                if (resultClass.isInstance(result.getCorrespondingDeclaration())) {
                    return resultClass.cast(result.getCorrespondingDeclaration());
                }
            } else {
                throw new UnsolvedSymbolException("We are unable to find the constructor declaration corresponding to " + node);
            }
        }
        if (node instanceof Parameter && ResolvedParameterDeclaration.class.equals(resultClass)) {
            Optional<ResolvedParameterDeclaration> resolvedParameterDeclaration;
            Parameter parameter = (Parameter)node;
            Optional parentNode = node.getParentNode();
            if (!parentNode.isPresent()) {
                throw new UnsolvedSymbolException("We are unable to resolve the parameter declaration corresponding to " + node);
            }
            Node parent = (Node)parentNode.get();
            if (parent instanceof ConstructorDeclaration) {
                resolvedParameterDeclaration = this.resolveParameterDeclaration((ResolvedMethodLikeDeclaration)((ConstructorDeclaration)parent).resolve(), parameter);
                return (T)resolvedParameterDeclaration.map(rpd -> resultClass.cast(rpd)).orElseThrow(() -> new UnsolvedSymbolException("We are unable to resolve the parameter declaration corresponding to " + node));
            }
            if (parent instanceof MethodDeclaration) {
                resolvedParameterDeclaration = this.resolveParameterDeclaration((ResolvedMethodLikeDeclaration)((MethodDeclaration)parent).resolve(), parameter);
                return (T)resolvedParameterDeclaration.map(rpd -> resultClass.cast(rpd)).orElseThrow(() -> new UnsolvedSymbolException("We are unable to resolve the parameter declaration corresponding to " + node));
            }
            if (parent instanceof RecordDeclaration) {
                resolvedParameterDeclaration = this.resolveParameterDeclaration(((RecordDeclaration)parent).resolve(), parameter);
                return (T)resolvedParameterDeclaration.map(rpd -> resultClass.cast(rpd)).orElseThrow(() -> new UnsolvedSymbolException("We are unable to resolve the parameter declaration corresponding to " + node));
            }
            if (parent instanceof LambdaExpr) {
                resolvedParameterDeclaration = this.resolveParameterDeclaration(parameter);
                return (T)resolvedParameterDeclaration.map(rpd -> resultClass.cast(rpd)).orElseThrow(() -> new UnsolvedSymbolException("We are unable to resolve the parameter declaration corresponding to " + node));
            }
            if (parent instanceof CatchClause) {
                resolvedParameterDeclaration = this.resolveParameterDeclaration(parameter);
                return (T)resolvedParameterDeclaration.map(rpd -> resultClass.cast(rpd)).orElseThrow(() -> new UnsolvedSymbolException("We are unable to resolve the parameter declaration corresponding to " + node));
            }
            throw new UnsolvedSymbolException("We are unable to resolve the parameter declaration corresponding to " + node);
        }
        if (node instanceof AnnotationExpr) {
            result = JavaParserFacade.get(this.typeSolver).solve((AnnotationExpr)node);
            if (result.isSolved()) {
                if (resultClass.isInstance(result.getCorrespondingDeclaration())) {
                    return resultClass.cast(result.getCorrespondingDeclaration());
                }
            } else {
                throw new UnsolvedSymbolException("We are unable to find the annotation declaration corresponding to " + node);
            }
        }
        if (node instanceof PatternExpr) {
            result = JavaParserFacade.get(this.typeSolver).solve((Expression)((PatternExpr)node));
            if (result.isSolved()) {
                if (resultClass.isInstance(result.getCorrespondingDeclaration())) {
                    return resultClass.cast(result.getCorrespondingDeclaration());
                }
            } else {
                throw new UnsolvedSymbolException("We are unable to find the method declaration corresponding to " + node);
            }
        }
        throw new UnsupportedOperationException("Unable to find the declaration of type " + resultClass.getSimpleName() + " from " + node.getClass().getSimpleName());
    }

    private Optional<ResolvedParameterDeclaration> resolveParameterDeclaration(ResolvedMethodLikeDeclaration resolvedMethodLikeDeclaration, Parameter parameter) {
        for (int i = 0; i < resolvedMethodLikeDeclaration.getNumberOfParams(); ++i) {
            if (!resolvedMethodLikeDeclaration.getParam(i).getName().equals(parameter.getNameAsString())) continue;
            return Optional.of(resolvedMethodLikeDeclaration.getParam(i));
        }
        return Optional.empty();
    }

    private Optional<ResolvedParameterDeclaration> resolveParameterDeclaration(ResolvedReferenceTypeDeclaration resolvedReferenceTypeDeclaration, final Parameter parameter) {
        final ResolvedFieldDeclaration rfd = resolvedReferenceTypeDeclaration.getField(parameter.getNameAsString());
        if (rfd == null) {
            return Optional.empty();
        }
        ResolvedParameterDeclaration resolvedParameterDeclaration = new ResolvedParameterDeclaration(){

            public ResolvedType getType() {
                return rfd.getType();
            }

            public String getName() {
                return parameter.getNameAsString();
            }

            public boolean isVariadic() {
                return parameter.isVarArgs();
            }
        };
        return Optional.of(resolvedParameterDeclaration);
    }

    private Optional<ResolvedParameterDeclaration> resolveParameterDeclaration(final Parameter parameter) {
        ResolvedParameterDeclaration resolvedParameterDeclaration = new ResolvedParameterDeclaration(){

            public ResolvedType getType() {
                Node parentNode = (Node)parameter.getParentNode().get();
                if (parameter.getType().isUnknownType() && parentNode instanceof LambdaExpr) {
                    Optional value = JavaParserFactory.getContext(parentNode, JavaSymbolSolver.this.typeSolver).solveSymbolAsValue(parameter.getNameAsString());
                    return value.map(v -> v.getType()).orElseThrow(() -> new UnsolvedSymbolException("We are unable to resolve the parameter declaration corresponding to " + parameter));
                }
                return JavaParserFacade.get(JavaSymbolSolver.this.typeSolver).convertToUsage(parameter.getType());
            }

            public String getName() {
                return parameter.getNameAsString();
            }

            public boolean isVariadic() {
                return parameter.isVarArgs();
            }
        };
        return Optional.of(resolvedParameterDeclaration);
    }

    public <T> T toResolvedType(Type javaparserType, Class<T> resultClass) {
        ResolvedType resolvedType = JavaParserFacade.get(this.typeSolver).convertToUsage(javaparserType);
        if (resultClass.isInstance(resolvedType)) {
            return resultClass.cast(resolvedType);
        }
        throw new UnsupportedOperationException("Unable to get the resolved type of class " + resultClass.getSimpleName() + " from " + javaparserType);
    }

    public ResolvedType calculateType(Expression expression) {
        return JavaParserFacade.get(this.typeSolver).getType((Node)expression);
    }

    public ResolvedReferenceTypeDeclaration toTypeDeclaration(Node node) {
        if (node instanceof ClassOrInterfaceDeclaration) {
            if (((ClassOrInterfaceDeclaration)node).isInterface()) {
                return new JavaParserInterfaceDeclaration((ClassOrInterfaceDeclaration)node, this.typeSolver);
            }
            return new JavaParserClassDeclaration((ClassOrInterfaceDeclaration)node, this.typeSolver);
        }
        if (node instanceof TypeParameter) {
            return new JavaParserTypeParameter((TypeParameter)node, this.typeSolver);
        }
        if (node instanceof EnumDeclaration) {
            return new JavaParserEnumDeclaration((EnumDeclaration)node, this.typeSolver);
        }
        if (node instanceof AnnotationDeclaration) {
            return new JavaParserAnnotationDeclaration((AnnotationDeclaration)node, this.typeSolver);
        }
        if (node instanceof EnumConstantDeclaration) {
            return new JavaParserEnumDeclaration((EnumDeclaration)Navigator.demandParentNode((Node)node), this.typeSolver);
        }
        throw new IllegalArgumentException("Cannot get a reference type declaration from " + node.getClass().getCanonicalName());
    }

    private static class ArrayLengthValueDeclaration
    implements ResolvedValueDeclaration {
        private static final ArrayLengthValueDeclaration INSTANCE = new ArrayLengthValueDeclaration();

        private ArrayLengthValueDeclaration() {
        }

        public String getName() {
            return "length";
        }

        public ResolvedType getType() {
            return ResolvedPrimitiveType.INT;
        }
    }
}

