/*
 * Decompiled with CFR 0.152.
 */
package org.hazlewood.connor.bottema.emailaddress;

import java.util.EnumSet;
import org.hazlewood.connor.bottema.emailaddress.Dragons;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressCriteria;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EmailAddressValidator {
    private EmailAddressValidator() {
    }

    public static boolean isValid(String email) {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/hazlewood/connor/bottema/emailaddress/EmailAddressValidator.isValid must not be null");
        }
        return EmailAddressValidator.isValid(email, EmailAddressCriteria.DEFAULT);
    }

    public static boolean isValidStrict(String email) {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/hazlewood/connor/bottema/emailaddress/EmailAddressValidator.isValidStrict must not be null");
        }
        return EmailAddressValidator.isValid(email, EmailAddressCriteria.RFC_COMPLIANT);
    }

    public static boolean isValid(@Nullable String email, @NotNull EnumSet<EmailAddressCriteria> criteria) {
        if (criteria == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/hazlewood/connor/bottema/emailaddress/EmailAddressValidator.isValid must not be null");
        }
        return EmailAddressValidator.isValidMailbox(email, Dragons.fromCriteria(criteria));
    }

    private static boolean isValidMailbox(@Nullable String email, @NotNull Dragons dragons) {
        if (dragons == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/hazlewood/connor/bottema/emailaddress/EmailAddressValidator.isValidMailbox must not be null");
        }
        return email != null && dragons.MAILBOX_PATTERN.matcher(email).matches();
    }
}

