/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.ScreenShotLaboratory;
import com.codeborne.selenide.impl.Screenshot;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebElement;

public class Screenshots {
    private static final ScreenShotLaboratory screenshots = (ScreenShotLaboratory)Plugins.inject((Object[])new ScreenShotLaboratory[0]);

    public static String saveScreenshotAndPageSource() {
        Driver driver = WebDriverRunner.driver();
        Config config = driver.config();
        return screenshots.takeScreenshot(driver, config.screenshots(), config.savePageSource()).summary();
    }

    public static Screenshot takeScreenShot(String className, String methodName) {
        return screenshots.takeScreenShot(WebDriverRunner.driver(), className, methodName);
    }

    public static @Nullable File takeScreenShotAsFile() {
        return screenshots.takeScreenShotAsFile(WebDriverRunner.driver());
    }

    public static File takeScreenShot(WebElement element) {
        return screenshots.takeScreenshot(WebDriverRunner.driver(), element);
    }

    public static @Nullable File takeScreenShot(WebElement iframe, SelenideElement element) {
        return screenshots.takeScreenshot(WebDriverRunner.driver(), iframe, element);
    }

    public static @Nullable BufferedImage takeScreenShotAsImage(WebElement iframe, SelenideElement element) {
        return screenshots.takeScreenshotAsImage(WebDriverRunner.driver(), iframe, element);
    }

    public static BufferedImage takeScreenShotAsImage(WebElement element) {
        return screenshots.takeScreenshotAsImage(WebDriverRunner.driver(), element);
    }

    public static void startContext(String className, String methodName) {
        screenshots.startContext(className, methodName);
    }

    @CanIgnoreReturnValue
    public static List<Screenshot> finishContext() {
        return screenshots.finishContext();
    }

    public static @Nullable File getLastScreenshot() {
        return screenshots.getLastScreenshot();
    }

    public static Optional<File> getLastThreadScreenshot() {
        return screenshots.getLastThreadScreenshot();
    }

    public static Optional<File> getLastContextScreenshot() {
        return screenshots.getLastContextScreenshot();
    }
}

