/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.AuthenticationType;
import com.codeborne.selenide.Clipboard;
import com.codeborne.selenide.Conditional;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.Container;
import com.codeborne.selenide.Credentials;
import com.codeborne.selenide.Device;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.LocalStorage;
import com.codeborne.selenide.ModalOptions;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.SelenideTargetLocator;
import com.codeborne.selenide.SelenideWait;
import com.codeborne.selenide.SessionStorage;
import com.codeborne.selenide.Stopwatch;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.logevents.SelenideLogger;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.SessionId;

public class Selenide {
    public static void open(String relativeOrAbsoluteUrl) {
        WebDriverRunner.getSelenideDriver().open(relativeOrAbsoluteUrl);
    }

    public static void open(String relativeOrAbsoluteUrl, Config config) {
        WebDriverRunner.getSelenideDriver().open(relativeOrAbsoluteUrl, config);
    }

    public static void open(URL absoluteUrl) {
        WebDriverRunner.getSelenideDriver().open(absoluteUrl);
    }

    public static void open(String relativeOrAbsoluteUrl, String domain, String login, String password) {
        WebDriverRunner.getSelenideDriver().open(relativeOrAbsoluteUrl, domain, login, password);
    }

    public static void open(String relativeOrAbsoluteUrl, AuthenticationType authenticationType, Credentials credentials) {
        WebDriverRunner.getSelenideDriver().open(relativeOrAbsoluteUrl, authenticationType, credentials);
    }

    public static void open(URL absoluteUrl, String domain, String login, String password) {
        WebDriverRunner.getSelenideDriver().open(absoluteUrl, domain, login, password);
    }

    public static void open() {
        WebDriverRunner.getSelenideDriver().open();
    }

    public static void open(Config config) {
        WebDriverRunner.getSelenideDriver().open(config);
    }

    public static Conditional<WebDriver> webdriver() {
        return WebDriverRunner.getSelenideDriver().webdriver();
    }

    public static void emulateDevice(Device device) {
        WebDriverRunner.getSelenideDriver().emulateDevice(device);
    }

    public static void resetEmulation() {
        WebDriverRunner.getSelenideDriver().resetEmulation();
    }

    public static void using(WebDriver webDriver, Runnable lambda) {
        WebDriverRunner.using(webDriver, lambda);
    }

    public static void using(WebDriver webDriver, SelenideProxyServer proxy, Runnable lambda) {
        WebDriverRunner.using(webDriver, proxy, lambda);
    }

    public static void inNewBrowser(Runnable lambda) {
        WebDriverRunner.inNewBrowser(lambda);
    }

    public static void inNewBrowser(Config config, Runnable lambda) {
        WebDriverRunner.inNewBrowser(config, lambda);
    }

    public static void updateHash(String hash) {
        WebDriverRunner.getSelenideDriver().updateHash(hash);
    }

    public static <PageObjectClass> PageObjectClass open(String relativeOrAbsoluteUrl, Class<PageObjectClass> pageObjectClassClass) {
        return (PageObjectClass)WebDriverRunner.getSelenideDriver().open(relativeOrAbsoluteUrl, pageObjectClassClass);
    }

    public static <PageObjectClass> PageObjectClass open(URL absoluteUrl, Class<PageObjectClass> pageObjectClassClass) {
        return (PageObjectClass)WebDriverRunner.getSelenideDriver().open(absoluteUrl, pageObjectClassClass);
    }

    public static <PageObjectClass> PageObjectClass open(String relativeOrAbsoluteUrl, String domain, String login, String password, Class<PageObjectClass> pageObjectClassClass) {
        return (PageObjectClass)WebDriverRunner.getSelenideDriver().open(relativeOrAbsoluteUrl, domain, login, password, pageObjectClassClass);
    }

    public static <PageObjectClass> PageObjectClass open(URL absoluteUrl, String domain, String login, String password, Class<PageObjectClass> pageObjectClassClass) {
        return (PageObjectClass)WebDriverRunner.getSelenideDriver().open(absoluteUrl, domain, login, password, pageObjectClassClass);
    }

    public static void closeWindow() {
        SelenideLogger.run((String)"current window", (String)SelenideLogger.getReadableSubject((String)"close", (Object[])new Object[0]), WebDriverRunner::closeWindow);
    }

    public static void closeWebDriver() {
        SelenideLogger.run((String)"webdriver", (String)SelenideLogger.getReadableSubject((String)"close", (Object[])new Object[0]), WebDriverRunner.getSelenideDriver()::close);
    }

    public static void refresh() {
        WebDriverRunner.getSelenideDriver().refresh();
    }

    public static void back() {
        WebDriverRunner.getSelenideDriver().back();
    }

    public static void forward() {
        WebDriverRunner.getSelenideDriver().forward();
    }

    public static @Nullable String title() {
        return WebDriverRunner.getSelenideDriver().title();
    }

    public static void sleep(long milliseconds) {
        Stopwatch.sleepAtLeast((long)milliseconds);
    }

    @CanIgnoreReturnValue
    public static @Nullable String screenshot(String fileName) {
        return WebDriverRunner.getSelenideDriver().screenshot(fileName);
    }

    @CanIgnoreReturnValue
    public static <T> @Nullable T screenshot(OutputType<T> outputType) {
        return (T)WebDriverRunner.getSelenideDriver().screenshot(outputType);
    }

    public static SelenideElement $(WebElement webElement) {
        return WebDriverRunner.getSelenideDriver().$(webElement);
    }

    public static <ContainerClass extends Container> ContainerClass $(WebElement webElement, Class<ContainerClass> containerClass) {
        return (ContainerClass)WebDriverRunner.getSelenideDriver().container(webElement, containerClass);
    }

    public static SelenideElement $(String cssSelector) {
        return WebDriverRunner.getSelenideDriver().find(cssSelector);
    }

    public static <ContainerClass extends Container> ContainerClass $(String cssSelector, Class<ContainerClass> containerClass) {
        return (ContainerClass)WebDriverRunner.getSelenideDriver().container(cssSelector, containerClass);
    }

    public static SelenideElement $x(String xpathExpression) {
        return WebDriverRunner.getSelenideDriver().$x(xpathExpression);
    }

    public static <ContainerClass extends Container> ContainerClass $x(String xpathExpression, Class<ContainerClass> containerClass) {
        return (ContainerClass)WebDriverRunner.getSelenideDriver().$x(xpathExpression, containerClass);
    }

    public static SelenideElement $(By seleniumSelector) {
        return WebDriverRunner.getSelenideDriver().find(seleniumSelector);
    }

    public static <ContainerClass extends Container> ContainerClass $(By seleniumSelector, Class<ContainerClass> containerClass) {
        return (ContainerClass)WebDriverRunner.getSelenideDriver().container(seleniumSelector, containerClass);
    }

    public static SelenideElement $(By seleniumSelector, int index) {
        return WebDriverRunner.getSelenideDriver().find(seleniumSelector, index);
    }

    public static <ContainerClass extends Container> ContainerClass $(By seleniumSelector, int index, Class<ContainerClass> containerClass) {
        return (ContainerClass)WebDriverRunner.getSelenideDriver().container(seleniumSelector, index, containerClass);
    }

    public static SelenideElement $(String cssSelector, int index) {
        return WebDriverRunner.getSelenideDriver().$(cssSelector, index);
    }

    public static <ContainerClass extends Container> ContainerClass $(String cssSelector, int index, Class<ContainerClass> containerClass) {
        return (ContainerClass)WebDriverRunner.getSelenideDriver().container(cssSelector, index, containerClass);
    }

    public static ElementsCollection $$(Collection<? extends WebElement> elements) {
        return WebDriverRunner.getSelenideDriver().$$(elements);
    }

    public static <ContainerClass extends Container> List<ContainerClass> $$(Collection<? extends WebElement> elements, Class<ContainerClass> containerClass) {
        return WebDriverRunner.getSelenideDriver().containers(elements, containerClass);
    }

    public static ElementsCollection $$(String cssSelector) {
        return WebDriverRunner.getSelenideDriver().$$(cssSelector);
    }

    public static <ContainerClass extends Container> List<ContainerClass> $$(String cssSelector, Class<ContainerClass> containerClass) {
        return WebDriverRunner.getSelenideDriver().containers(cssSelector, containerClass);
    }

    public static ElementsCollection $$x(String xpathExpression) {
        return WebDriverRunner.getSelenideDriver().$$x(xpathExpression);
    }

    public static <ContainerClass extends Container> List<ContainerClass> $$x(String xpathExpression, Class<ContainerClass> containerClass) {
        return WebDriverRunner.getSelenideDriver().$$x(xpathExpression, containerClass);
    }

    public static ElementsCollection $$(By seleniumSelector) {
        return WebDriverRunner.getSelenideDriver().$$(seleniumSelector);
    }

    public static <ContainerClass extends Container> List<ContainerClass> $$(By seleniumSelector, Class<ContainerClass> containerClass) {
        return WebDriverRunner.getSelenideDriver().containers(seleniumSelector, containerClass);
    }

    public static SelenideElement element(WebElement webElement) {
        return WebDriverRunner.getSelenideDriver().$(webElement);
    }

    public static SelenideElement element(String cssSelector) {
        return WebDriverRunner.getSelenideDriver().$(cssSelector);
    }

    public static SelenideElement element(By seleniumSelector) {
        return WebDriverRunner.getSelenideDriver().$(seleniumSelector);
    }

    public static SelenideElement element(By seleniumSelector, int index) {
        return WebDriverRunner.getSelenideDriver().$(seleniumSelector, index);
    }

    public static SelenideElement element(String cssSelector, int index) {
        return WebDriverRunner.getSelenideDriver().$(cssSelector, index);
    }

    public static ElementsCollection elements(Collection<? extends WebElement> elements) {
        return WebDriverRunner.getSelenideDriver().$$(elements);
    }

    public static ElementsCollection elements(String cssSelector) {
        return WebDriverRunner.getSelenideDriver().$$(cssSelector);
    }

    public static ElementsCollection elements(By seleniumSelector) {
        return WebDriverRunner.getSelenideDriver().$$(seleniumSelector);
    }

    @CanIgnoreReturnValue
    public static <T> @Nullable T executeJavaScript(String jsCode, Object ... arguments) {
        return (T)WebDriverRunner.getSelenideDriver().executeJavaScript(jsCode, arguments);
    }

    @CanIgnoreReturnValue
    public static <T> @Nullable T executeAsyncJavaScript(String jsCode, Object ... arguments) {
        return (T)WebDriverRunner.getSelenideDriver().executeAsyncJavaScript(jsCode, arguments);
    }

    public static @Nullable SelenideElement getSelectedRadio(By radioField) {
        return WebDriverRunner.getSelenideDriver().getSelectedRadio(radioField);
    }

    @CanIgnoreReturnValue
    public static String confirm() {
        return Selenide.confirm(ModalOptions.none());
    }

    @CanIgnoreReturnValue
    public static String confirm(@Nullable String expectedDialogText) {
        return Selenide.confirm(ModalOptions.withExpectedText((String)expectedDialogText));
    }

    @CanIgnoreReturnValue
    public static String confirm(ModalOptions options) {
        return WebDriverRunner.getSelenideDriver().modal().confirm(options);
    }

    @CanIgnoreReturnValue
    public static String prompt() {
        return Selenide.prompt(ModalOptions.none(), null);
    }

    @CanIgnoreReturnValue
    public static String prompt(@Nullable String inputText) {
        return Selenide.prompt(ModalOptions.none(), inputText);
    }

    @CanIgnoreReturnValue
    public static String prompt(@Nullable String expectedDialogText, @Nullable String inputText) {
        return Selenide.prompt(ModalOptions.withExpectedText((String)expectedDialogText), inputText);
    }

    @CanIgnoreReturnValue
    public static String prompt(ModalOptions options, @Nullable String inputText) {
        return WebDriverRunner.getSelenideDriver().modal().prompt(options, inputText);
    }

    @CanIgnoreReturnValue
    public static String dismiss() {
        return Selenide.dismiss(ModalOptions.none());
    }

    @CanIgnoreReturnValue
    public static String dismiss(@Nullable String expectedDialogText) {
        return Selenide.dismiss(ModalOptions.withExpectedText((String)expectedDialogText));
    }

    @CanIgnoreReturnValue
    public static String dismiss(ModalOptions options) {
        return WebDriverRunner.getSelenideDriver().modal().dismiss(options);
    }

    public static SelenideTargetLocator switchTo() {
        return WebDriverRunner.getSelenideDriver().driver().switchTo();
    }

    public static SelenideElement getFocusedElement() {
        return WebDriverRunner.getSelenideDriver().getFocusedElement();
    }

    public static String getSelectedText() {
        return WebDriverRunner.getSelenideDriver().getSelectedText();
    }

    @CanIgnoreReturnValue
    public static String copy() {
        return WebDriverRunner.getSelenideDriver().copy();
    }

    public static <PageObjectClass> PageObjectClass page(Class<PageObjectClass> pageObjectClass) {
        return (PageObjectClass)WebDriverRunner.getSelenideDriver().page(pageObjectClass);
    }

    @SafeVarargs
    public static <PageObjectClass> PageObjectClass page(PageObjectClass ... reified) {
        return (PageObjectClass)WebDriverRunner.getSelenideDriver().page(reified);
    }

    public static <PageObjectClass, T extends PageObjectClass> PageObjectClass page(T pageObject) {
        return (PageObjectClass)WebDriverRunner.getSelenideDriver().page(pageObject);
    }

    public static <ContainerClass extends Container> ContainerClass container(WebElement element, Class<ContainerClass> containerClass) {
        return (ContainerClass)WebDriverRunner.getSelenideDriver().container(element, containerClass);
    }

    public static <ContainerClass extends Container> ContainerClass container(By seleniumSelector, Class<ContainerClass> containerClass) {
        return (ContainerClass)WebDriverRunner.getSelenideDriver().container(seleniumSelector, containerClass);
    }

    public static <ContainerClass extends Container> ContainerClass container(By seleniumSelector, int index, Class<ContainerClass> containerClass) {
        return (ContainerClass)WebDriverRunner.getSelenideDriver().container(seleniumSelector, index, containerClass);
    }

    public static <ContainerClass extends Container> ContainerClass container(String cssSelector, Class<ContainerClass> containerClass) {
        return (ContainerClass)WebDriverRunner.getSelenideDriver().container(cssSelector, containerClass);
    }

    public static <ContainerClass extends Container> ContainerClass container(String cssSelector, int index, Class<ContainerClass> containerClass) {
        return (ContainerClass)WebDriverRunner.getSelenideDriver().container(cssSelector, index, containerClass);
    }

    public static <ContainerClass extends Container> List<ContainerClass> containers(Collection<? extends WebElement> elements, Class<ContainerClass> containerClass) {
        return WebDriverRunner.getSelenideDriver().containers(elements, containerClass);
    }

    public static <ContainerClass extends Container> List<ContainerClass> containers(String cssSelector, Class<ContainerClass> containerClass) {
        return WebDriverRunner.getSelenideDriver().containers(cssSelector, containerClass);
    }

    public static <ContainerClass extends Container> List<ContainerClass> containers(By seleniumSelector, Class<ContainerClass> containerClass) {
        return WebDriverRunner.getSelenideDriver().containers(seleniumSelector, containerClass);
    }

    public static SelenideWait Wait() {
        return WebDriverRunner.getSelenideDriver().Wait();
    }

    public static Actions actions() {
        return WebDriverRunner.getSelenideDriver().driver().actions();
    }

    public static void zoom(double factor) {
        WebDriverRunner.getSelenideDriver().zoom(factor);
    }

    public static List<String> getWebDriverLogs(String logType) {
        return WebDriverRunner.getSelenideDriver().getWebDriverLogs().logs(logType);
    }

    public static List<String> getWebDriverLogs(String logType, Level logLevel) {
        return WebDriverRunner.getSelenideDriver().getWebDriverLogs().logs(logType, logLevel);
    }

    public static void clearBrowserCookies() {
        WebDriverRunner.getSelenideDriver().clearCookies();
    }

    public static void clearBrowserLocalStorage() {
        WebDriverRunner.getSelenideDriver().clearBrowserLocalStorage();
    }

    public static String getUserAgent() {
        return WebDriverRunner.getSelenideDriver().driver().getUserAgent();
    }

    public static boolean atBottom() {
        return WebDriverRunner.getSelenideDriver().atBottom();
    }

    public static File download(String url) throws URISyntaxException {
        return WebDriverRunner.getSelenideDriver().download(url);
    }

    public static File download(URI url) {
        return WebDriverRunner.getSelenideDriver().download(url);
    }

    public static File download(URI url, long timeoutMs) {
        return WebDriverRunner.getSelenideDriver().download(url, timeoutMs);
    }

    public static File download(String url, long timeoutMs) throws URISyntaxException {
        return WebDriverRunner.getSelenideDriver().download(new URI(url), timeoutMs);
    }

    public static LocalStorage localStorage() {
        return WebDriverRunner.getSelenideDriver().getLocalStorage();
    }

    public static SessionStorage sessionStorage() {
        return WebDriverRunner.getSelenideDriver().getSessionStorage();
    }

    public static Clipboard clipboard() {
        return WebDriverRunner.getSelenideDriver().getClipboard();
    }

    public static SessionId sessionId() {
        return WebDriverRunner.getSelenideDriver().getSessionId();
    }
}

