/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.fullscreenshot;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.JavaScript;
import com.codeborne.selenide.impl.Photographer;
import com.codeborne.selenide.impl.WebdriverPhotographer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chromium.HasCdp;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.v140.page.Page;
import org.openqa.selenium.devtools.v140.page.model.Viewport;
import org.openqa.selenium.firefox.HasFullPageScreenshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullSizePhotographer
implements Photographer {
    private static final Logger log = LoggerFactory.getLogger(FullSizePhotographer.class);
    private static final JavaScript js = new JavaScript("get-screen-size.js");
    private final WebdriverPhotographer defaultImplementation;

    public FullSizePhotographer() {
        this(new WebdriverPhotographer());
    }

    protected FullSizePhotographer(WebdriverPhotographer defaultImplementation) {
        this.defaultImplementation = defaultImplementation;
    }

    public <T> Optional<T> takeScreenshot(Driver driver, OutputType<T> outputType) {
        try {
            Optional result = this.takeFullSizeScreenshot(driver, outputType);
            return result.isPresent() ? result : this.defaultImplementation.takeScreenshot(driver, outputType);
        }
        catch (WebDriverException e) {
            log.error("Failed to take full-size screenshot", (Throwable)e);
            return this.defaultImplementation.takeScreenshot(driver, outputType);
        }
    }

    private <T> Optional<T> takeFullSizeScreenshot(Driver driver, OutputType<T> outputType) {
        WebDriver webDriver = driver.getWebDriver();
        if (webDriver instanceof HasFullPageScreenshot) {
            HasFullPageScreenshot firefoxDriver = (HasFullPageScreenshot)webDriver;
            return Optional.of(firefoxDriver.getFullPageScreenshotAs(outputType));
        }
        if (webDriver instanceof HasCdp) {
            return this.takeScreenshotWithCDP((WebDriver)((HasCdp)webDriver), outputType);
        }
        if (webDriver instanceof HasDevTools) {
            return this.takeScreenshot((WebDriver)((HasDevTools)webDriver), outputType);
        }
        return Optional.empty();
    }

    private <WD extends WebDriver & HasDevTools, ResultType> Optional<ResultType> takeScreenshot(WD devtoolsDriver, OutputType<ResultType> outputType) {
        DevTools devTools = ((HasDevTools)devtoolsDriver).getDevTools();
        devTools.createSessionIfThereIsNotOne(devtoolsDriver.getWindowHandle());
        Options options = this.getOptions(devtoolsDriver);
        Viewport viewport = new Viewport((Number)0, (Number)0, (Number)options.fullWidth(), (Number)options.fullHeight(), (Number)1);
        String base64 = (String)devTools.send(Page.captureScreenshot(Optional.empty(), Optional.empty(), Optional.of(viewport), Optional.empty(), Optional.of(options.exceedViewport()), Optional.of(true)));
        Object screenshot = outputType.convertFromBase64Png(base64);
        return Optional.of(screenshot);
    }

    private <WD extends WebDriver & HasCdp, ResultType> Optional<ResultType> takeScreenshotWithCDP(WD cdpDriver, OutputType<ResultType> outputType) {
        Options options = this.getOptions(cdpDriver);
        Map<String, Boolean> captureScreenshotOptions = Map.of("clip", Map.of("x", 0, "y", 0, "width", options.fullWidth(), "height", options.fullHeight(), "scale", 1), "captureBeyondViewport", options.exceedViewport());
        Map result = ((HasCdp)cdpDriver).executeCdpCommand("Page.captureScreenshot", captureScreenshotOptions);
        String base64 = (String)result.get("data");
        Object screenshot = outputType.convertFromBase64Png(base64);
        return Optional.of(screenshot);
    }

    private Options getOptions(WebDriver webDriver) {
        Map size = Objects.requireNonNull((Map)js.execute((SearchContext)webDriver, new Object[0]));
        return new Options((Long)size.get("fullWidth"), (Long)size.get("fullHeight"), (Boolean)size.get("exceedViewport"));
    }

    private record Options(long fullWidth, long fullHeight, boolean exceedViewport) {
    }
}

