/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.SelenideDriver;
import com.codeborne.selenide.impl.HttpHelper;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import com.codeborne.selenide.webdriver.BrowserResizer;
import com.codeborne.selenide.webdriver.ChromeDriverFactory;
import com.codeborne.selenide.webdriver.DefaultDriverFactory;
import com.codeborne.selenide.webdriver.DriverFactory;
import com.codeborne.selenide.webdriver.EdgeDriverFactory;
import com.codeborne.selenide.webdriver.FirefoxDriverFactory;
import com.codeborne.selenide.webdriver.InternetExplorerDriverFactory;
import com.codeborne.selenide.webdriver.RemoteDriverFactory;
import com.codeborne.selenide.webdriver.SafariDriverFactory;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(WebDriverFactory.class);
    private final Map<String, Class<? extends AbstractDriverFactory>> factories = this.factories();
    private final RemoteDriverFactory remoteDriverFactory = new RemoteDriverFactory();
    private final BrowserResizer browserResizer = new BrowserResizer();

    private Map<String, Class<? extends AbstractDriverFactory>> factories() {
        return Map.of("chrome", ChromeDriverFactory.class, "firefox", FirefoxDriverFactory.class, "edge", EdgeDriverFactory.class, "internet explorer", InternetExplorerDriverFactory.class, "ie", InternetExplorerDriverFactory.class, "safari", SafariDriverFactory.class);
    }

    public WebDriver createWebDriver(Config config, @Nullable Proxy proxy, @Nullable File browserDownloadsFolder) {
        String remote = HttpHelper.maskUrlCredentials(config.remote());
        log.debug("Creating webdriver in thread {}: browser={}, browser.version={}, browser.size={}, remote={}, downloadsFolder: {}", new Object[]{Thread.currentThread().getId(), config.browser(), config.browserVersion(), config.browserSize(), remote, browserDownloadsFolder});
        Browser browser = new Browser(config.browser(), config.headless());
        WebDriver webdriver = this.createWebDriverInstance(config, browser, proxy, browserDownloadsFolder);
        if (this.needBrowserResize(webdriver)) {
            this.browserResizer.adjustBrowserSize(config, webdriver);
        }
        this.browserResizer.adjustBrowserPosition(config, webdriver);
        this.setLoadTimeout(config, webdriver);
        this.logVersions(webdriver);
        return webdriver;
    }

    private boolean needBrowserResize(WebDriver webdriver) {
        Browser browser;
        String browserName = "";
        if (webdriver instanceof HasCapabilities) {
            HasCapabilities hasCapabilities = (HasCapabilities)webdriver;
            Capabilities capabilities = hasCapabilities.getCapabilities();
            browserName = capabilities.getBrowserName();
        }
        return !(browser = new Browser(browserName, false)).isChromium() && !"msedge".equals(browserName);
    }

    private void setLoadTimeout(Config config, WebDriver webdriver) {
        if (config.pageLoadTimeout() < 0L) {
            return;
        }
        try {
            webdriver.manage().timeouts().pageLoadTimeout(Duration.ofMillis(config.pageLoadTimeout()));
        }
        catch (UnsupportedCommandException e) {
            log.info("Failed to set page load timeout to {} ms: {}", (Object)config.pageLoadTimeout(), (Object)e.toString());
        }
        catch (RuntimeException e) {
            log.error("Failed to set page load timeout to {} ms", (Object)config.pageLoadTimeout(), (Object)e);
        }
    }

    private WebDriver createWebDriverInstance(Config config, Browser browser, @Nullable Proxy proxy, @Nullable File browserDownloadsFolder) {
        DriverFactory webdriverFactory = this.findFactory(browser);
        if (config.remote() != null) {
            MutableCapabilities capabilities = webdriverFactory.createCapabilities(config, browser, proxy, browserDownloadsFolder);
            return this.remoteDriverFactory.create(config, capabilities);
        }
        return webdriverFactory.create(config, browser, proxy, browserDownloadsFolder);
    }

    private DriverFactory findFactory(Browser browser) {
        Class<DefaultDriverFactory> factoryClass = this.factories.getOrDefault(browser.name.toLowerCase(Locale.ROOT), DefaultDriverFactory.class);
        try {
            return (DriverFactory)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to initialize " + factoryClass.getName(), e);
        }
    }

    private void logVersions(WebDriver webdriver) {
        BuildInfo seleniumInfo = new BuildInfo();
        log.info("Selenide {} / Selenium {} / {}", new Object[]{SelenideDriver.class.getPackage().getImplementationVersion(), seleniumInfo.getReleaseLabel(), this.getBrowserVersion(webdriver)});
    }

    private String getBrowserVersion(WebDriver webdriver) {
        if (webdriver instanceof HasCapabilities) {
            HasCapabilities hasCapabilities = (HasCapabilities)webdriver;
            Capabilities c = hasCapabilities.getCapabilities();
            return "%s %s %s".formatted(c.getBrowserName(), c.getBrowserVersion(), c.getPlatformName());
        }
        return webdriver.getClass().getName();
    }
}

