/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractChromiumDriverFactory;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeDriverFactory
extends AbstractChromiumDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(EdgeDriverFactory.class);

    @Override
    public WebDriver create(Config config, Browser browser, @Nullable Proxy proxy, @Nullable File browserDownloadsFolder) {
        EdgeOptions options = this.createCapabilities(config, browser, proxy, browserDownloadsFolder);
        EdgeDriverService driverService = this.createDriverService(config);
        return new EdgeDriver(driverService, options);
    }

    private EdgeDriverService createDriverService(Config config) {
        return (EdgeDriverService)this.withLog(config, new EdgeDriverService.Builder());
    }

    public EdgeOptions createCapabilities(Config config, Browser browser, @Nullable Proxy proxy, @Nullable File browserDownloadsFolder) {
        EdgeOptions options = this.createCommonCapabilities(new EdgeOptions(), config, browser, proxy);
        options.setCapability("acceptInsecureCerts", true);
        if (config.headless()) {
            this.addHeadless(options);
        }
        if (StringUtils.isNotEmpty((CharSequence)config.browserBinary())) {
            log.info("Using browser binary: {}", (Object)config.browserBinary());
            options.setBinary(config.browserBinary());
        }
        options.addArguments(this.createEdgeArguments(config));
        options.setExperimentalOption("prefs", this.prefs(browserDownloadsFolder, System.getProperty("edgeoptions.prefs", "")));
        this.setMobileEmulation(options);
        return options;
    }

    protected void addHeadless(EdgeOptions options) {
        options.addArguments(new String[]{"--headless=new"});
    }

    protected List<String> createEdgeArguments(Config config) {
        return this.createChromiumArguments(config, System.getProperty("edgeoptions.args"));
    }

    private void setMobileEmulation(EdgeOptions options) {
        Map<String, Object> mobileEmulation = this.mobileEmulation();
        if (!mobileEmulation.isEmpty()) {
            options.setExperimentalOption("mobileEmulation", mobileEmulation);
        }
    }

    protected Map<String, Object> mobileEmulation() {
        String mobileEmulation = System.getProperty("edgeoptions.mobileEmulation", "");
        return this.parsePreferencesFromString(mobileEmulation);
    }
}

