/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.selector;

import com.codeborne.selenide.TextMatchOptions;
import com.codeborne.selenide.impl.JavaScript;
import com.codeborne.selenide.selector.OptimizedBy;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class SearchByText
extends OptimizedBy {
    private static final JavaScript js = new JavaScript("find-elements-by-text.js");
    private final String elementText;
    private final TextMatchOptions options;

    public SearchByText(String elementText, TextMatchOptions options) {
        this.elementText = elementText;
        this.options = options;
    }

    @Override
    protected List<WebElement> findElements(SearchContext context, int limit) {
        return Objects.requireNonNull((List)js.execute(context, js.node(context), this.elementText, this.options.toMap(), limit));
    }

    public String toString() {
        return "by text \"%s\" (%s)".formatted(this.elementText, this.options);
    }
}

