/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.selector;

import com.codeborne.selenide.TextMatchOptions;
import com.codeborne.selenide.impl.JavaScript;
import com.codeborne.selenide.selector.OptimizedBy;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class SearchByAttribute
extends OptimizedBy {
    private static final JavaScript js = new JavaScript("find-elements-by-attribute.js");
    private final String attributeName;
    private final String attributeValue;
    private final TextMatchOptions options;

    public SearchByAttribute(String attributeName, String attributeValue, TextMatchOptions options) {
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.options = options;
    }

    @Override
    protected List<WebElement> findElements(SearchContext context, int limit) {
        return Objects.requireNonNull((List)js.execute(context, js.node(context), this.attributeName, this.attributeValue, this.options.toMap(), limit));
    }

    public String toString() {
        return "by \"%s\"=\"%s\" (%s)".formatted(this.attributeName, this.attributeValue, this.options);
    }
}

