/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.selector;

import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.JavaScript;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ByShadowCss
extends By
implements Serializable {
    private static final JavaScript jsSource = new JavaScript("find-in-shadow-roots.js");
    private final List<String> shadowHostsChain;
    private final String target;

    public ByShadowCss(String target, String ... shadowHostsChain) {
        if (target == null) {
            throw new IllegalArgumentException("Cannot find elements when the selector is null");
        }
        this.shadowHostsChain = List.of(shadowHostsChain);
        this.target = target;
    }

    public static By cssSelector(String target, String ... shadowHostsChain) {
        return new ByShadowCss(target, shadowHostsChain);
    }

    public WebElement findElement(SearchContext context) {
        List<WebElement> found = this.findElements(context);
        if (found.isEmpty()) {
            throw new NoSuchElementException("Cannot locate an element " + this.target + " in shadow roots " + this.describeShadowRoots());
        }
        return found.get(0);
    }

    public List<WebElement> findElements(SearchContext context) {
        try {
            if (context instanceof WebElement) {
                return Objects.requireNonNullElse((List)jsSource.execute(context, this.target, this.shadowHostsChain, context), Collections.emptyList());
            }
            return Objects.requireNonNullElse((List)jsSource.execute(context, this.target, this.shadowHostsChain), Collections.emptyList());
        }
        catch (JavascriptException e) {
            throw new NoSuchElementException(Cleanup.of.webdriverExceptionMessage(e));
        }
    }

    public String toString() {
        return "By.cssSelector: " + this.describeShadowRoots() + " -> " + this.target;
    }

    private String describeShadowRoots() {
        return String.join((CharSequence)" -> ", this.shadowHostsChain);
    }
}

