/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.proxy;

import com.browserup.bup.BrowserUpProxy;
import com.browserup.bup.client.ClientUtil;
import com.browserup.bup.filters.RequestFilter;
import com.browserup.bup.filters.ResponseFilter;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.proxy.AuthenticationFilter;
import com.codeborne.selenide.proxy.BrowserUpProxyServerUnlimited;
import com.codeborne.selenide.proxy.FileDownloadFilter;
import com.codeborne.selenide.proxy.MockResponseFilter;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.net.DefaultNetworkInterfaceProvider;
import org.openqa.selenium.net.NetworkInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelenideProxyServer {
    private static final Logger log = LoggerFactory.getLogger(SelenideProxyServer.class);
    private static final Pattern REGEX_HOST_NAME = Pattern.compile("(.*):.*");
    private static final Pattern REGEX_PORT = Pattern.compile(".*:(.*)");
    private final Config config;
    private final @Nullable Proxy outsideProxy;
    private @Nullable Proxy seleniumProxy;
    private final BrowserUpProxy proxy;
    private final Map<String, RequestFilter> requestFilters = new LinkedHashMap<String, RequestFilter>();
    private final Map<String, ResponseFilter> responseFilters = new LinkedHashMap<String, ResponseFilter>();
    private final AtomicInteger port = new AtomicInteger();

    public SelenideProxyServer(Config config, @Nullable Proxy outsideProxy) {
        this(config, outsideProxy, (BrowserUpProxy)new BrowserUpProxyServerUnlimited());
    }

    protected SelenideProxyServer(Config config, @Nullable Proxy outsideProxy, BrowserUpProxy proxy) {
        this.config = config;
        this.outsideProxy = outsideProxy;
        this.proxy = proxy;
    }

    public synchronized @Nullable Proxy getSeleniumProxy() {
        if (this.seleniumProxy == null) {
            this.seleniumProxy = this.createSeleniumProxy();
        }
        return this.seleniumProxy;
    }

    public void start() {
        this.proxy.setTrustAllServers(true);
        if (this.outsideProxy != null) {
            this.proxy.setChainedProxy(SelenideProxyServer.getProxyAddress(this.outsideProxy));
            String noProxy = this.outsideProxy.getNoProxy();
            if (noProxy != null) {
                List<String> noProxyHosts = Arrays.asList(noProxy.split(","));
                this.proxy.setChainedProxyNonProxyHosts(noProxyHosts);
            }
        }
        FileDownloadFilter downloadFilter = new FileDownloadFilter(this.config);
        this.addRequestFilter("selenide.proxy.filter.mockResponse", new MockResponseFilter());
        this.addRequestFilter("selenide.proxy.filter.authentication", new AuthenticationFilter());
        this.addRequestFilter("selenide.proxy.filter.download", downloadFilter);
        this.addResponseFilter("selenide.proxy.filter.download", downloadFilter);
        this.proxy.start(this.config.proxyPort());
        this.port.set(this.proxy.getPort());
    }

    public boolean isStarted() {
        return this.proxy.isStarted();
    }

    public void addRequestFilter(String name, RequestFilter requestFilter) {
        Object currentFilter = this.requestFilter(name);
        if (currentFilter != null && !currentFilter.equals(requestFilter)) {
            throw new IllegalArgumentException("Duplicate request filter: " + name);
        }
        if (currentFilter == null) {
            this.proxy.addRequestFilter(requestFilter);
            this.requestFilters.put(name, requestFilter);
        }
    }

    @CanIgnoreReturnValue
    public @Nullable RequestFilter removeRequestFilter(String name) {
        RequestFilter filter = this.requestFilters.remove(name);
        this.proxy.removeRequestFilter(filter);
        return filter;
    }

    public void addResponseFilter(String name, ResponseFilter responseFilter) {
        Object currentFilter = this.responseFilter(name);
        if (currentFilter != null && !currentFilter.equals(responseFilter)) {
            throw new IllegalArgumentException("Duplicate response filter: " + name);
        }
        if (currentFilter == null) {
            this.proxy.addResponseFilter(responseFilter);
            this.responseFilters.put(name, responseFilter);
        }
    }

    @CanIgnoreReturnValue
    public @Nullable ResponseFilter removeResponseFilter(String name) {
        ResponseFilter filter = this.responseFilters.remove(name);
        this.proxy.removeResponseFilter(filter);
        return filter;
    }

    public void cleanupFilters() {
        this.requestFilterNames().stream().filter(name -> !name.startsWith("selenide.proxy.filter.")).forEach(this::removeRequestFilter);
        this.responseFilterNames().stream().filter(name -> !name.startsWith("selenide.proxy.filter.")).forEach(this::removeResponseFilter);
    }

    static InetSocketAddress getProxyAddress(Proxy proxy) {
        String httpProxy = proxy.getHttpProxy();
        String host = REGEX_HOST_NAME.matcher(httpProxy).replaceFirst("$1");
        String port = REGEX_PORT.matcher(httpProxy).replaceFirst("$1");
        return new InetSocketAddress(host, Integer.parseInt(port));
    }

    private Proxy createSeleniumProxy() {
        return StringUtils.isEmpty((CharSequence)this.config.proxyHost()) ? ClientUtil.createSeleniumProxy((BrowserUpProxy)this.proxy, (String)this.guessHostName()) : ClientUtil.createSeleniumProxy((BrowserUpProxy)this.proxy, (String)this.config.proxyHost());
    }

    private String guessHostName() {
        String seleniumHostName;
        String browserupHostName = ClientUtil.getConnectableAddress().getHostAddress();
        if (Objects.equals(browserupHostName, seleniumHostName = this.getNonLoopbackAddressOfThisMachine()) || seleniumHostName.isEmpty()) {
            log.info("Using proxy host: '{}'", (Object)seleniumHostName);
        } else {
            log.info("Using proxy host resolved by Selenium: '{}' (fyi BrowserUpProxy resolved : '{}')", (Object)seleniumHostName, (Object)browserupHostName);
        }
        return seleniumHostName;
    }

    private String getNonLoopbackAddressOfThisMachine() {
        for (NetworkInterface iface : new DefaultNetworkInterfaceProvider().getNetworkInterfaces()) {
            InetAddress ip4NonLoopback = iface.getIp4NonLoopBackOnly();
            if (ip4NonLoopback == null) continue;
            return ip4NonLoopback.getHostAddress();
        }
        return "";
    }

    public void shutdown() {
        if (this.proxy.isStarted()) {
            try {
                this.proxy.stop();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public BrowserUpProxy getProxy() {
        return this.proxy;
    }

    public String toString() {
        return String.format("Selenide proxy server: %s", this.port.get());
    }

    public Map<String, RequestFilter> requestFilters() {
        return this.requestFilters;
    }

    public List<String> requestFilterNames() {
        return this.requestFilters.keySet().stream().toList();
    }

    public <T extends RequestFilter> @Nullable T requestFilter(String name) {
        return (T)this.requestFilters.get(name);
    }

    public Map<String, ResponseFilter> responseFilters() {
        return this.responseFilters;
    }

    public List<String> responseFilterNames() {
        return this.responseFilters.keySet().stream().toList();
    }

    public <T extends ResponseFilter> @Nullable T responseFilter(String name) {
        return (T)this.responseFilters.get(name);
    }

    public MockResponseFilter responseMocker() {
        return Objects.requireNonNull((MockResponseFilter)this.requestFilter("selenide.proxy.filter.mockResponse"));
    }
}

