/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.proxy;

import com.browserup.bup.filters.RequestFilter;
import com.browserup.bup.util.HttpMessageContents;
import com.browserup.bup.util.HttpMessageInfo;
import com.codeborne.selenide.proxy.RequestMatcher;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.remote.http.Contents;

public class MockResponseFilter
implements RequestFilter {
    private static final int HTTP_STATUS_OK = 200;
    private static final byte[] EMPTY_RESPONSE = new byte[0];
    private final Map<String, ResponseMock> mocks = new LinkedHashMap<String, ResponseMock>();

    public void mockText(String name, RequestMatcher requestMatcher, Supplier<String> mockedResponse) {
        this.mockBytes(name, requestMatcher, () -> ((String)mockedResponse.get()).getBytes(StandardCharsets.UTF_8));
    }

    public void mockText(String name, RequestMatcher requestMatcher, int status, Supplier<String> mockedResponse) {
        this.mockBytes(name, requestMatcher, status, () -> ((String)mockedResponse.get()).getBytes(StandardCharsets.UTF_8));
    }

    public void mockBytes(String name, RequestMatcher requestMatcher, Supplier<byte[]> mockedResponse) {
        this.mockBytes(name, requestMatcher, 200, mockedResponse);
    }

    public void mockBytes(String name, RequestMatcher requestMatcher, int status, Supplier<byte[]> mockedResponse) {
        this.mockResponse(name, requestMatcher, () -> (org.openqa.selenium.remote.http.HttpResponse)new org.openqa.selenium.remote.http.HttpResponse().setStatus(status).setContent(Contents.bytes((byte[])((byte[])mockedResponse.get()))));
    }

    public void mockResponse(String name, RequestMatcher requestMatcher, Supplier<org.openqa.selenium.remote.http.HttpResponse> mockedResponse) {
        if (this.mocks.containsKey(name)) {
            throw new IllegalArgumentException("Response filter already registered: " + name);
        }
        this.mocks.put(name, new ResponseMock(name, requestMatcher, mockedResponse));
    }

    public void reset(String name) {
        if (this.mocks.remove(name) == null) {
            throw new IllegalArgumentException("Response filter was not registered: " + name);
        }
    }

    public void resetAll() {
        this.mocks.clear();
    }

    public @Nullable HttpResponse filterRequest(HttpRequest request, HttpMessageContents contents, HttpMessageInfo messageInfo) {
        for (ResponseMock mock : this.mocks.values()) {
            if (!mock.requestMatcher.match(request, contents, messageInfo)) continue;
            return request.method().equals((Object)HttpMethod.OPTIONS) ? this.mockOptionsRequest(request, mock) : this.mockRequest(request, mock);
        }
        return null;
    }

    private DefaultFullHttpResponse mockOptionsRequest(HttpRequest request, ResponseMock mock) {
        HttpHeaders headers = new DefaultHttpHeaders().add("Content-Length", (Object)"0").add("Access-Control-Allow-Methods", (Object)"*").add("Access-Control-Allow-Headers", (Object)"*").add("Access-Control-Allow-Origin", (Object)"*").add("Access-Control-Max-Age", (Object)"0").add("X-Mocked-By", (Object)mock.name);
        return MockResponseFilter.response(request, 200, Unpooled.wrappedBuffer((byte[])EMPTY_RESPONSE), headers);
    }

    private DefaultFullHttpResponse mockRequest(HttpRequest request, ResponseMock mock) {
        org.openqa.selenium.remote.http.HttpResponse httpResponse = mock.mockedResponse.get();
        HttpHeaders headers = new DefaultHttpHeaders().add("Content-Length", (Object)httpResponse.getContent().length()).set("Access-Control-Allow-Origin", (Object)"*").add("X-Mocked-By", (Object)mock.name);
        httpResponse.forEachHeader((name, value) -> headers.add(name, value));
        ByteBuf content = this.readBytes(mock.name, (Supplier<InputStream>)httpResponse.getContent());
        return MockResponseFilter.response(request, httpResponse.getStatus(), content, headers);
    }

    private ByteBuf readBytes(String mockName, Supplier<InputStream> source) {
        ByteBuf byteBuf;
        block8: {
            InputStream in = source.get();
            try {
                byteBuf = Unpooled.wrappedBuffer((byte[])in.readAllBytes());
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read mocked response content for " + mockName, e);
                }
            }
            in.close();
        }
        return byteBuf;
    }

    private static DefaultFullHttpResponse response(HttpRequest request, int status, ByteBuf content, HttpHeaders headers) {
        return new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.valueOf((int)status), content, headers, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
    }

    private static final class ResponseMock {
        private final String name;
        private final RequestMatcher requestMatcher;
        private final Supplier<org.openqa.selenium.remote.http.HttpResponse> mockedResponse;

        private ResponseMock(String name, RequestMatcher requestMatcher, Supplier<org.openqa.selenium.remote.http.HttpResponse> mockedResponse) {
            this.name = name;
            this.requestMatcher = requestMatcher;
            this.mockedResponse = mockedResponse;
        }
    }
}

