/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.impl.BiDiUti;
import com.codeborne.selenide.impl.Photographer;
import java.time.Duration;
import java.util.Optional;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.browsingcontext.BrowsingContext;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.v143.page.Page;

public class WebdriverPhotographer
implements Photographer {
    @Override
    public <T> Optional<T> takeScreenshot(WebDriver webDriver, OutputType<T> outputType) {
        if (webDriver instanceof HasDevTools) {
            HasDevTools hasDevTools = (HasDevTools)webDriver;
            return Optional.of(outputType.convertFromBase64Png(this.takeScreenshotWithDevtools((WebDriver)hasDevTools)));
        }
        if (BiDiUti.isBiDiEnabled(webDriver)) {
            return Optional.of(outputType.convertFromBase64Png(this.takeScreenshotWithBidi((WebDriver)((HasBiDi)webDriver))));
        }
        if (webDriver instanceof TakesScreenshot) {
            TakesScreenshot takesScreenshot = (TakesScreenshot)webDriver;
            Object screenshot = takesScreenshot.getScreenshotAs(outputType);
            return Optional.of(screenshot);
        }
        return Optional.empty();
    }

    private <T extends WebDriver & HasDevTools> String takeScreenshotWithDevtools(T driver) {
        String windowHandle = driver.getWindowHandle();
        DevTools devTools = ((HasDevTools)driver).getDevTools();
        devTools.createSessionIfThereIsNotOne(windowHandle);
        return (String)devTools.send(Page.captureScreenshot(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(true)), Duration.ofSeconds(4L));
    }

    private <T extends WebDriver & HasBiDi> String takeScreenshotWithBidi(T webDriver) {
        String windowHandle = webDriver.getWindowHandle();
        BrowsingContext browsingContext = new BrowsingContext(webDriver, windowHandle);
        return browsingContext.captureScreenshot();
    }
}

