/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.As;
import com.codeborne.selenide.Container;
import com.codeborne.selenide.DeepShadow;
import com.codeborne.selenide.ShadowHost;
import com.codeborne.selenide.impl.ShadowHostBuilder;
import com.codeborne.selenide.selector.ByDeepShadow;
import java.lang.reflect.Field;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.support.pagefactory.Annotations;

class SelenideAnnotations
extends Annotations {
    SelenideAnnotations(@Nullable Field field) {
        super(field);
    }

    public By buildBy() {
        By ans = super.buildBy();
        Field field = this.getField();
        if (field.isAnnotationPresent(ShadowHost.class)) {
            ans = this.buildShadowHost(ans, field);
        }
        if (field.isAnnotationPresent(DeepShadow.class)) {
            ans = this.buildByDeepShadow(ans);
        }
        return ans;
    }

    protected void assertValidAnnotations() {
        super.assertValidAnnotations();
        Field field = this.getField();
        ShadowHost shadowHost = field.getAnnotation(ShadowHost.class);
        DeepShadow deepShadow = field.getAnnotation(DeepShadow.class);
        if (shadowHost != null && deepShadow != null) {
            throw new IllegalArgumentException("If you use a '@ShadowHost' annotation, you must not also use a '@DeepShadow' annotation");
        }
    }

    private By buildShadowHost(By target, Field field) {
        ShadowHost shadowHost = field.getAnnotation(ShadowHost.class);
        return new ShadowHostBuilder(target).buildIt(shadowHost, field);
    }

    private By buildByDeepShadow(By target) {
        return new ByDeepShadow(target);
    }

    public boolean isShadowHost() {
        Field field = this.getField();
        return field != null && field.isAnnotationPresent(Container.ShadowRoot.class);
    }

    public @Nullable String getAlias() {
        As as = this.alias();
        return as == null ? null : as.value();
    }

    private @Nullable As alias() {
        Field field = this.getField();
        return field == null ? null : field.getAnnotation(As.class);
    }

    public static @Nullable As aliasOf(Field field) {
        return new SelenideAnnotations(field).alias();
    }

    public static boolean isShadowRoot(Class<?> type) {
        return type.isAnnotationPresent(Container.ShadowRoot.class);
    }

    public static boolean isShadowRoot(@Nullable Field field) {
        return new SelenideAnnotations(field).isShadowHost();
    }

    public static boolean isShadowRoot(@Nullable Field field, Class<?> type) {
        return SelenideAnnotations.isShadowRoot(field) || SelenideAnnotations.isShadowRoot(type);
    }
}

