/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.BiDiException;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.log.GenericLogEntry;
import org.openqa.selenium.bidi.log.Log;
import org.openqa.selenium.bidi.log.LogLevel;
import org.openqa.selenium.bidi.log.StackFrame;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.remote.http.ConnectionFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiDiUti {
    private static final Logger log = LoggerFactory.getLogger(BiDiUti.class);

    public static boolean isBiDiEnabled(WebDriver webDriver) {
        try {
            HasBiDi hasBiDi;
            return webDriver instanceof HasBiDi && (hasBiDi = (HasBiDi)webDriver).getBiDi() != null;
        }
        catch (BiDiException notEnabled) {
            return false;
        }
    }

    public static Optional<BiDi> getBiDiIfEnabled(WebDriver webDriver) {
        try {
            Optional<BiDi> optional;
            if (webDriver instanceof HasBiDi) {
                HasBiDi hasBiDi = (HasBiDi)webDriver;
                optional = Optional.of(hasBiDi.getBiDi());
            } else {
                optional = Optional.empty();
            }
            return optional;
        }
        catch (BiDiException | ConnectionFailedException notEnabled) {
            return Optional.empty();
        }
    }

    public static List<LogEntry> collectBrowserLogs(WebDriver webDriver) {
        return BiDiUti.getBiDiIfEnabled(webDriver).map(biDi -> {
            CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
            biDi.addListener(Log.entryAdded(), logEntry -> {
                log.trace("Received browser log {}", logEntry);
                logs.addAll(BiDiUti.readBiDiLogEntry(logEntry));
            });
            return logs;
        }).orElse(Collections.emptyList());
    }

    private static List<LogEntry> readBiDiLogEntry(org.openqa.selenium.bidi.log.LogEntry logEntry) {
        return Stream.of(logEntry.getConsoleLogEntry(), logEntry.getGenericLogEntry(), logEntry.getJavascriptLogEntry()).flatMap(Optional::stream).map(entry -> BiDiUti.readBiDiLogEntry(entry)).toList();
    }

    private static LogEntry readBiDiLogEntry(GenericLogEntry log) {
        return new LogEntry(BiDiUti.readBiDiLogLevel(log.getLevel()), log.getTimestamp(), BiDiUti.readBiDiLogMessage(log));
    }

    private static String readBiDiLogMessage(GenericLogEntry log) {
        if (log.getStackTrace() == null || log.getStackTrace().getCallFrames().isEmpty()) {
            return log.getText();
        }
        StackFrame frame = (StackFrame)log.getStackTrace().getCallFrames().get(0);
        return "%s %s:%s %s".formatted(frame.getUrl(), frame.getLineNumber(), frame.getColumnNumber(), log.getText());
    }

    private static Level readBiDiLogLevel(LogLevel level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case LogLevel.DEBUG -> Level.FINE;
            case LogLevel.INFO -> Level.INFO;
            case LogLevel.WARNING -> Level.WARNING;
            case LogLevel.ERROR -> Level.SEVERE;
        };
    }
}

