/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

public class Alias {
    private final String text;
    public static final Alias NONE = new NoneAlias();

    public Alias(String text) {
        if (text.isEmpty()) {
            throw new IllegalArgumentException("Empty alias not allowed");
        }
        this.text = text;
    }

    public String getOrElse(Supplier<String> defaultValue) {
        return this.text;
    }

    public String get(Supplier<String> defaultValue) {
        return this.text + " {" + defaultValue.get() + "}";
    }

    public String appendable() {
        return this.getText() == null ? "" : " \"" + this.getText() + "\"";
    }

    public @Nullable String getText() {
        return this.text;
    }

    private static final class NoneAlias
    extends Alias {
        NoneAlias() {
            super("-");
        }

        @Override
        public String getOrElse(Supplier<String> defaultValue) {
            return defaultValue.get();
        }

        @Override
        public String get(Supplier<String> defaultValue) {
            return defaultValue.get();
        }

        @Override
        public @Nullable String getText() {
            return null;
        }
    }
}

