/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.files;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadedFile {
    private static final Logger log = LoggerFactory.getLogger(DownloadedFile.class);
    private final File file;
    private final long lastModifiedTime;
    private final long size;
    private final Map<String, String> headers;

    public DownloadedFile(File file, long lastModifiedTime, long size, Map<String, String> headers) {
        this.file = file;
        this.lastModifiedTime = lastModifiedTime;
        this.size = size;
        this.headers = headers;
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.file.getName();
    }

    public String extension() {
        return FilenameUtils.getExtension((String)this.file.getName());
    }

    public long size() {
        return this.size;
    }

    public boolean hasContentDispositionHeader() {
        return this.headers.containsKey("content-disposition");
    }

    public @Nullable String getContentType() {
        return this.headers.get("content-type");
    }

    public long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public boolean isFileModifiedLaterThan(long timestamp) {
        return this.lastModifiedTime - timestamp >= -1000L;
    }

    public String toString() {
        return String.format("%s (modified %s ms ago)", this.file.getName(), this.file.exists() ? Long.valueOf(System.currentTimeMillis() - this.file.lastModified()) : "?");
    }

    public static DownloadedFile fileWithName(String fileName) {
        return new DownloadedFile(new File(fileName), 0L, 0L, Collections.emptyMap());
    }

    public static DownloadedFile localFile(File file) {
        try {
            BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return new DownloadedFile(file, attributes.lastModifiedTime().toMillis(), attributes.size(), Collections.emptyMap());
        }
        catch (IOException e) {
            log.debug("Failed to get file attributes: {}", (Object)file.getAbsolutePath(), (Object)e);
            return new DownloadedFile(file, 0L, 0L, Collections.emptyMap());
        }
    }
}

