/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.drivercommands.BrowserHealthChecker;
import com.codeborne.selenide.impl.WebDriverInstance;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.logging.LogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverWrapper
implements Driver {
    private static final Logger log = LoggerFactory.getLogger(WebDriverWrapper.class);
    private final WebDriverInstance wd;
    private final BrowserHealthChecker browserHealthChecker = new BrowserHealthChecker();

    public WebDriverWrapper(Config config, WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy, DownloadsFolder browserDownloadsFolder) {
        this(new WebDriverInstance(config, webDriver, selenideProxy, browserDownloadsFolder));
    }

    private WebDriverWrapper(WebDriverInstance wd) {
        this.wd = wd;
    }

    @Override
    public Config config() {
        return this.wd.config();
    }

    @Override
    public Browser browser() {
        return new Browser(this.wd.config().browser(), this.wd.config().headless());
    }

    @Override
    public boolean hasWebDriverStarted() {
        return this.wd.webDriver() != null;
    }

    @Override
    public WebDriver getWebDriver() {
        return this.wd.webDriver();
    }

    @Override
    public SelenideProxyServer getProxy() {
        return this.wd.proxy();
    }

    @Override
    public WebDriver getAndCheckWebDriver() {
        if (this.wd.webDriver() == null || !this.browserHealthChecker.isBrowserStillOpen(this.wd.webDriver())) {
            log.info("Webdriver has been closed meanwhile");
            this.close();
            throw new IllegalStateException("Webdriver has been closed meanwhile");
        }
        return this.wd.webDriver();
    }

    @Override
    public @Nullable DownloadsFolder browserDownloadsFolder() {
        return this.wd.downloadsFolder();
    }

    @Override
    public List<LogEntry> getBrowserLogs() {
        return this.wd.browserLogs();
    }

    @Override
    public void close() {
        this.wd.dispose();
    }
}

