/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.AuthenticationType;
import com.codeborne.selenide.BasicAuthCredentials;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.Credentials;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.FileDownloadMode;
import com.codeborne.selenide.SelenideDriver;
import com.codeborne.selenide.drivercommands.BasicAuthUtils;
import com.codeborne.selenide.impl.HttpHelper;
import com.codeborne.selenide.logevents.SelenideLogger;
import com.codeborne.selenide.proxy.AuthenticationFilter;
import java.net.URL;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class Navigator {
    private static final Pattern ABSOLUTE_URL_REGEX = Pattern.compile("^[a-zA-Z-]+:.*", 32);

    public void open(SelenideDriver driver, String relativeOrAbsoluteUrl) {
        this.navigateTo(driver, relativeOrAbsoluteUrl, null, null);
    }

    public void open(SelenideDriver driver, URL url) {
        this.navigateTo(driver, url.toExternalForm(), null, null);
    }

    public void open(SelenideDriver driver, String relativeOrAbsoluteUrl, String domain, String login, String password) {
        this.navigateTo(driver, relativeOrAbsoluteUrl, AuthenticationType.BASIC, new BasicAuthCredentials(domain, login, password));
    }

    public void open(SelenideDriver driver, URL url, String domain, String login, String password) {
        this.navigateTo(driver, url.toExternalForm(), AuthenticationType.BASIC, new BasicAuthCredentials(domain, login, password));
    }

    public void open(SelenideDriver driver, String relativeOrAbsoluteUrl, AuthenticationType authenticationType, Credentials credentials) {
        this.navigateTo(driver, relativeOrAbsoluteUrl, authenticationType, credentials);
    }

    private AuthenticationFilter basicAuthRequestFilter(SelenideDriver driver) {
        return Objects.requireNonNull((AuthenticationFilter)driver.getProxy().requestFilter("selenide.proxy.filter.authentication"));
    }

    String absoluteUrl(Config config, String relativeOrAbsoluteUrl) {
        return this.isAbsoluteUrl(relativeOrAbsoluteUrl) ? relativeOrAbsoluteUrl : config.baseUrl() + relativeOrAbsoluteUrl;
    }

    private void navigateTo(SelenideDriver driver, String relativeOrAbsoluteUrl, @Nullable AuthenticationType authenticationType, @Nullable Credentials credentials) {
        this.checkThatProxyIsEnabled(driver.config());
        String absoluteUrl = this.absoluteUrl(driver.config(), relativeOrAbsoluteUrl);
        SelenideLogger.run("open", absoluteUrl, () -> {
            try {
                WebDriver webDriver = driver.getAndCheckWebDriver();
                String url = this.prepareAuthentication(driver, absoluteUrl, authenticationType, credentials);
                webDriver.navigate().to(url);
            }
            catch (WebDriverException e) {
                e.addInfo("selenide.url", HttpHelper.maskUrlCredentials(absoluteUrl));
                e.addInfo("selenide.baseUrl", HttpHelper.maskUrlCredentials(driver.config().baseUrl()));
                String gridUrl = driver.config().remote();
                if (gridUrl != null) {
                    e.addInfo("selenide.remote", HttpHelper.maskUrlCredentials(gridUrl));
                }
                throw e;
            }
        });
    }

    public void open(SelenideDriver driver) {
        this.checkThatProxyIsEnabled(driver.config());
        SelenideLogger.run("open", "", driver::getAndCheckWebDriver);
    }

    private void checkThatProxyIsEnabled(Config config) {
        if (!config.proxyEnabled() && config.fileDownload() == FileDownloadMode.PROXY) {
            throw new IllegalStateException("config.proxyEnabled == false but config.fileDownload == PROXY. You need to enable proxy server to download file using PROXY mode.");
        }
    }

    private String prepareAuthentication(SelenideDriver driver, String requestUrl, @Nullable AuthenticationType authenticationType, @Nullable Credentials credentials) {
        if (driver.config().proxyEnabled()) {
            this.basicAuthRequestFilter(driver).removeAuthentication();
        }
        if (credentials == null || authenticationType == null) {
            return requestUrl;
        }
        if (driver.config().proxyEnabled()) {
            this.basicAuthRequestFilter(driver).setAuthentication(authenticationType, credentials);
            return requestUrl;
        }
        if (BasicAuthUtils.registerBasicAuth(driver.getWebDriver(), credentials)) {
            return requestUrl;
        }
        if (authenticationType == AuthenticationType.BASIC) {
            return BasicAuthUtils.appendBasicAuthToURL(requestUrl, (BasicAuthCredentials)credentials);
        }
        throw new UnsupportedOperationException("Cannot use " + String.valueOf((Object)authenticationType) + " authentication without proxy server");
    }

    boolean isAbsoluteUrl(String relativeOrAbsoluteUrl) {
        return ABSOLUTE_URL_REGEX.matcher(relativeOrAbsoluteUrl).matches();
    }

    public void back(Driver driver) {
        SelenideLogger.run("back", "", () -> driver.getWebDriver().navigate().back());
    }

    public void forward(Driver driver) {
        SelenideLogger.run("forward", "", () -> driver.getWebDriver().navigate().forward());
    }

    public void refresh(Driver driver) {
        SelenideLogger.run("refresh", "", () -> driver.getWebDriver().navigate().refresh());
    }
}

