/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.drivercommands.BrowserHealthChecker;
import com.codeborne.selenide.drivercommands.CreateDriverCommand;
import com.codeborne.selenide.drivercommands.WebdriversRegistry;
import com.codeborne.selenide.impl.WebDriverInstance;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import com.codeborne.selenide.webdriver.WebDriverFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.support.events.WebDriverListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyDriver
implements Driver {
    private static final Logger log = LoggerFactory.getLogger(LazyDriver.class);
    private final Config config;
    private final BrowserHealthChecker browserHealthChecker;
    private final WebDriverFactory factory;
    private final CreateDriverCommand createDriverCommand;
    private final @Nullable Proxy userProvidedProxy;
    private final List<WebDriverListener> listeners;
    private final Browser browser;
    private boolean closed;
    private @Nullable WebDriverInstance wd;

    public LazyDriver(Config config, @Nullable Proxy userProvidedProxy, List<WebDriverListener> listeners) {
        this(config, userProvidedProxy, listeners, new WebDriverFactory(), new BrowserHealthChecker(), new CreateDriverCommand());
    }

    LazyDriver(Config config, @Nullable Proxy userProvidedProxy, List<WebDriverListener> listeners, WebDriverFactory factory, BrowserHealthChecker browserHealthChecker, CreateDriverCommand createDriverCommand) {
        this.config = config;
        this.browser = new Browser(config.browser(), config.headless());
        this.userProvidedProxy = userProvidedProxy;
        this.listeners = new ArrayList<WebDriverListener>(listeners);
        this.factory = factory;
        this.browserHealthChecker = browserHealthChecker;
        this.createDriverCommand = createDriverCommand;
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public Browser browser() {
        return this.browser;
    }

    @Override
    public boolean hasWebDriverStarted() {
        return this.wd != null && this.wd.webDriver() != null;
    }

    @Override
    public WebDriver getWebDriver() {
        return this.checkDriverIsStarted().webDriver();
    }

    @Override
    public SelenideProxyServer getProxy() {
        return this.checkDriverIsStarted().proxy();
    }

    private WebDriverInstance checkDriverIsStarted() {
        if (this.closed) {
            throw new IllegalStateException("Webdriver has been closed. You need to call open(url) to open a browser again.");
        }
        if (this.wd == null || this.wd.webDriver() == null) {
            throw new IllegalStateException("No webdriver is bound to current thread: " + Thread.currentThread().getId() + ". You need to call open(url) first.");
        }
        return this.wd;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public WebDriver getAndCheckWebDriver() {
        if (this.wd != null && this.wd.webDriver() != null && !this.browserHealthChecker.isBrowserStillOpen(this.wd.webDriver())) {
            if (this.config.reopenBrowserOnFail()) {
                log.info("Webdriver has been closed meanwhile. Let's re-create it.");
                this.close();
                this.createDriver();
                return this.getWebDriver();
            }
            this.close();
            throw new IllegalStateException("Webdriver for current thread: " + Thread.currentThread().getId() + " has been closed meanwhile, and cannot create a new webdriver because reopenBrowserOnFail=false");
        }
        if (this.wd != null) {
            if (this.wd.webDriver() != null) return this.getWebDriver();
        }
        log.info("No webdriver is bound to current thread: {} - let's create a new webdriver", (Object)Thread.currentThread().getId());
        this.createDriver();
        return this.getWebDriver();
    }

    @Override
    public @Nullable DownloadsFolder browserDownloadsFolder() {
        return this.wd == null ? null : this.wd.downloadsFolder();
    }

    @Override
    public List<LogEntry> getBrowserLogs() {
        return this.wd == null ? Collections.emptyList() : this.wd.browserLogs();
    }

    void createDriver() {
        this.wd = this.createDriverCommand.createDriver(this.config, this.factory, this.userProvidedProxy, this.listeners);
        this.closed = false;
    }

    @Override
    public void close() {
        if (this.wd != null) {
            WebdriversRegistry.unregister(this.wd);
            this.wd.dispose();
        }
        this.wd = null;
        this.closed = true;
    }
}

