/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.webdriver;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.ObjectCondition;
import java.util.Objects;
import org.openqa.selenium.WebDriver;

public class Title
implements ObjectCondition<WebDriver> {
    private final String expectedTitle;

    public Title(String expectedTitle) {
        this.expectedTitle = expectedTitle;
    }

    @Override
    public String expectedValue() {
        return this.expectedTitle;
    }

    @Override
    public String description() {
        return "should have title " + this.expectedTitle;
    }

    @Override
    public String negativeDescription() {
        return "should not have title " + this.expectedTitle;
    }

    @Override
    public String describe(WebDriver webDriver) {
        return "Page";
    }

    @Override
    public CheckResult check(WebDriver webDriver) {
        String title = webDriver.getTitle();
        return this.result(webDriver, Objects.equals(title, this.expectedTitle), title);
    }
}

