/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.webdriver;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.ObjectCondition;
import com.codeborne.selenide.impl.JavaScript;
import java.util.Objects;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;

public abstract class CurrentFrameCondition
implements ObjectCondition<WebDriver> {
    private final String name;
    protected final String expectedUrl;

    protected CurrentFrameCondition(String name, String expectedUrl) {
        this.name = name;
        this.expectedUrl = expectedUrl;
    }

    @Override
    public String description() {
        return "should have url " + this.name + this.expectedUrl;
    }

    @Override
    public String negativeDescription() {
        return "should not have url " + this.name + this.expectedUrl;
    }

    @Override
    public String expectedValue() {
        return this.expectedUrl;
    }

    protected String getCurrentFrameUrl(WebDriver webDriver) {
        return Objects.requireNonNull(JavaScript.jsExecutor((SearchContext)webDriver).executeScript("return window.location.href", new Object[0])).toString();
    }

    @Override
    public String describe(WebDriver webDriver) {
        return "current frame";
    }

    @Override
    public CheckResult check(WebDriver webDriver) {
        String url = this.getCurrentFrameUrl(webDriver);
        return this.result(webDriver, this.test(url), url);
    }

    protected abstract boolean test(String var1);
}

