/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.sessionstorage;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.ObjectCondition;
import com.codeborne.selenide.SessionStorage;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class ItemWithValue
implements ObjectCondition<SessionStorage> {
    private final String item;
    private final String value;

    public ItemWithValue(String item, String value) {
        this.item = item;
        this.value = value;
    }

    @Override
    public String description() {
        return String.format("should have item '%s' with value '%s'", this.item, this.value);
    }

    @Override
    public String negativeDescription() {
        return String.format("should not have item '%s' with value '%s'", this.item, this.value);
    }

    private String actualValue(SessionStorage sessionStorage) {
        return sessionStorage.getItems().toString();
    }

    @Override
    public @Nullable String expectedValue() {
        return String.format("%s=%s", this.item, this.value);
    }

    @Override
    public CheckResult check(SessionStorage sessionStorage) {
        String itemValue = sessionStorage.getItem(this.item);
        return this.result(sessionStorage, Objects.equals(itemValue, this.value), this.actualValue(sessionStorage));
    }

    @Override
    public String describe(SessionStorage sessionStorage) {
        return "sessionStorage";
    }
}

