/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.datetime;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementCondition;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Objects;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TemporalFormatCondition<T extends TemporalAccessor>
extends WebElementCondition {
    private static final Logger log = LoggerFactory.getLogger(TemporalFormatCondition.class);
    private final String pattern;
    private final DateTimeFormatter format;

    protected TemporalFormatCondition(String name, String pattern) {
        super(name);
        this.pattern = pattern;
        this.format = DateTimeFormatter.ofPattern(pattern);
    }

    protected TemporalFormatCondition(String name, DateTimeFormatter format) {
        super(name);
        this.pattern = format.toString();
        this.format = format;
    }

    protected abstract TemporalQuery<T> queryFromTemporal();

    @Override
    public CheckResult check(Driver driver, WebElement element) {
        String value = this.getActualValue(element);
        try {
            return CheckResult.accepted(this.format.parse((CharSequence)value, this.queryFromTemporal()));
        }
        catch (DateTimeParseException exception) {
            log.debug("Unable to parse date string {}: {}", (Object)value, (Object)exception.toString());
            return CheckResult.rejected(exception.toString(), value);
        }
    }

    @Override
    public String toString() {
        return String.format("%s \"%s\"", this.getName(), this.pattern);
    }

    private String getActualValue(WebElement element) {
        String value = element.getAttribute("value");
        return Objects.requireNonNullElseGet(value, () -> ((WebElement)element).getText());
    }

    public String format(T value) {
        return this.format.format((TemporalAccessor)value);
    }
}

