/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.clipboard;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Clipboard;
import com.codeborne.selenide.ObjectCondition;

public class Content
implements ObjectCondition<Clipboard> {
    private final String expectedContent;

    public Content(String expectedContent) {
        this.expectedContent = expectedContent;
    }

    @Override
    public String description() {
        return String.format("should have content '%s'", this.expectedContent);
    }

    @Override
    public String negativeDescription() {
        return String.format("should not have content '%s'", this.expectedContent);
    }

    @Override
    public CheckResult check(Clipboard clipboard) {
        String clipboardText = clipboard.getText();
        return this.result(clipboard, clipboardText.equals(this.expectedContent), clipboardText);
    }

    @Override
    public String expectedValue() {
        return this.expectedContent;
    }

    @Override
    public String describe(Clipboard clipboard) {
        return "clipboard";
    }
}

