/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.TextCheck;
import com.codeborne.selenide.WebElementCondition;
import org.openqa.selenium.WebElement;

public abstract class TextCondition
extends WebElementCondition {
    private final String expectedText;

    protected TextCondition(String name, String expectedText) {
        super(name);
        this.expectedText = expectedText;
    }

    protected abstract boolean match(String var1, String var2);

    protected boolean match(TextCheck textCheck, String actualText, String expectedText) {
        return this.match(actualText, expectedText);
    }

    protected String getText(Driver driver, WebElement element) {
        return element.getText();
    }

    @Override
    public CheckResult check(Driver driver, WebElement element) {
        String elementText = this.getText(driver, element);
        boolean match = this.match(driver.config().textCheck(), elementText, this.expectedText);
        return new CheckResult(match, (Object)String.format("text=\"%s\"", elementText));
    }

    @Override
    public final String toString() {
        return String.format("%s \"%s\"", this.getName(), this.expectedText);
    }
}

