/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.impl.ElementDescriber;
import com.codeborne.selenide.impl.Plugins;
import java.util.Objects;
import org.openqa.selenium.WebElement;

public class Focused
extends WebElementCondition {
    private final ElementDescriber describe = Plugins.inject(ElementDescriber.class);

    public Focused() {
        super("focused");
    }

    private WebElement getFocusedElement(Driver driver) {
        return Objects.requireNonNull((WebElement)driver.executeJavaScript("return document.activeElement", new Object[0]));
    }

    @Override
    public CheckResult check(Driver driver, WebElement webElement) {
        WebElement focusedElement = this.getFocusedElement(driver);
        boolean focused = webElement.equals(focusedElement);
        String description = "Focused element: " + this.describe.briefly(driver, focusedElement) + ", current element: " + this.describe.briefly(driver, webElement);
        return new CheckResult(focused, (Object)description);
    }
}

