/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.InvalidStateError;
import com.codeborne.selenide.impl.Arguments;
import com.codeborne.selenide.impl.JavaScript;
import com.codeborne.selenide.impl.WebElementSource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class SelectOptionByTextOrIndex
implements Command<Void> {
    private static final JavaScript selectOptionByIndex = new JavaScript("select-options-by-index.js");
    private static final JavaScript selectOptionByText = new JavaScript("select-options-by-text.js");

    @Override
    public @Nullable Void execute(SelenideElement proxy, WebElementSource selectField, Object @Nullable [] args) {
        String[] otherTexts;
        Arguments arguments = new Arguments(args);
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("Missing arguments");
        }
        Object object = args[0];
        if (object instanceof String) {
            String firstOptionText = (String)object;
            otherTexts = Objects.requireNonNull((String[])arguments.nth(1));
            List<String> texts = Util.merge(firstOptionText, otherTexts);
            this.selectOptionsByTexts(selectField, texts);
            return null;
        }
        otherTexts = args[0];
        if (otherTexts instanceof Integer) {
            Integer firstOptionIndex = (Integer)otherTexts;
            int[] otherIndexes = Objects.requireNonNull((int[])arguments.nth(1));
            this.selectOptionsByIndexes(selectField, Util.merge(firstOptionIndex, otherIndexes));
            return null;
        }
        throw new IllegalArgumentException("Unsupported argument (expected String or Integer): " + Arrays.toString(args));
    }

    private void selectOptionsByTexts(WebElementSource selectField, List<String> texts) {
        Map error = Objects.requireNonNull((Map)selectOptionByText.execute(selectField.driver(), selectField.getWebElement(), texts));
        if (error.containsKey("nonSelect")) {
            throw new IllegalArgumentException("Cannot select option from a non-select element");
        }
        if (error.containsKey("disabledSelect")) {
            throw new InvalidStateError(selectField.description(), "Cannot select option in a disabled select");
        }
        if (error.containsKey("disabledOptions")) {
            List optionsTexts = (List)Util.cast(error.get("disabledOptions"));
            String elementDescription = String.format("%s/option[text:%s]", selectField.description(), Util.arrayToString(optionsTexts));
            throw new InvalidStateError(elementDescription, "Cannot select a disabled option");
        }
        if (error.containsKey("optionsNotFound")) {
            List optionsTexts = (List)Util.cast(error.get("optionsNotFound"));
            String elementDescription = String.format("%s/option[text:%s]", selectField.getSearchCriteria(), Util.arrayToString(optionsTexts));
            throw new ElementNotFound(selectField.getAlias(), elementDescription, Condition.exist);
        }
    }

    private void selectOptionsByIndexes(WebElementSource selectField, List<Integer> indexes) {
        Map error = Objects.requireNonNull((Map)selectOptionByIndex.execute(selectField.driver(), selectField.getWebElement(), indexes));
        if (error.containsKey("nonSelect")) {
            throw new IllegalArgumentException("Cannot select option from a non-select element");
        }
        if (error.containsKey("disabledSelect")) {
            throw new InvalidStateError(selectField.description(), "Cannot select option in a disabled select");
        }
        if (error.containsKey("disabledOptions")) {
            List index = (List)Util.cast(error.get("disabledOptions"));
            String elementDescription = String.format("%s/option[index:%s]", selectField.description(), Util.arrayToString(index));
            throw new InvalidStateError(elementDescription, "Cannot select a disabled option");
        }
        if (error.containsKey("optionsNotFound")) {
            List index = (List)Util.cast(error.get("optionsNotFound"));
            String elementDescription = String.format("%s/option[index:%s]", selectField.getSearchCriteria(), Util.arrayToString(index));
            throw new ElementNotFound(selectField.getAlias(), elementDescription, Condition.exist);
        }
    }
}

