/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.ClickMethod;
import com.codeborne.selenide.ClickOptions;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.FluentCommand;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.impl.JavaScript;
import com.codeborne.selenide.impl.WebElementSource;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class Click
extends FluentCommand {
    private final JavaScript jsSource = new JavaScript("click.js");

    @Override
    public void execute(WebElementSource locator, Object @Nullable [] args) {
        ClickOptions clickOptions = this.options(args);
        this.click(locator.driver(), this.findElement(locator, clickOptions.isForce()), clickOptions);
    }

    protected ClickOptions options(Object @Nullable [] args) {
        return switch (Util.size(args)) {
            case 0 -> ClickOptions.usingDefaultMethod();
            case 1 -> (ClickOptions)Util.firstOf(args);
            default -> throw new IllegalArgumentException("Unsupported click arguments: " + Arrays.toString(args));
        };
    }

    protected WebElement findElement(WebElementSource locator, boolean force) {
        return force ? locator.getWebElement() : locator.findAndAssertElementIsClickable();
    }

    protected void click(Driver driver, WebElement webElement, ClickOptions clickOptions) {
        Duration timeout = clickOptions.timeout();
        if (timeout == null || timeout.toMillis() == driver.config().pageLoadTimeout()) {
            this.doClick(driver, webElement, clickOptions);
        } else {
            this.withTimeout(driver, timeout, () -> this.doClick(driver, webElement, clickOptions));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withTimeout(Driver driver, Duration timeout, Runnable lambda) {
        WebDriver.Timeouts wdTimeouts = driver.getWebDriver().manage().timeouts();
        Duration originalPageLoadTimeout = wdTimeouts.getPageLoadTimeout();
        try {
            wdTimeouts.pageLoadTimeout(timeout);
            lambda.run();
        }
        finally {
            wdTimeouts.pageLoadTimeout(originalPageLoadTimeout);
        }
    }

    private void doClick(Driver driver, WebElement webElement, ClickOptions clickOptions) {
        ClickMethod method = this.detectMethod(driver, clickOptions);
        switch (method) {
            case DEFAULT: {
                this.defaultClick(driver, webElement, clickOptions.offsetX(), clickOptions.offsetY(), clickOptions.holdingKeys());
                break;
            }
            case JS: {
                this.clickViaJS(driver, webElement, clickOptions.offsetX(), clickOptions.offsetY(), clickOptions.holdingKeys());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown click option: " + String.valueOf((Object)method));
            }
        }
    }

    private ClickMethod detectMethod(Driver driver, ClickOptions clickOptions) {
        ClickMethod method = clickOptions.clickMethod();
        return method == ClickMethod.DEFAULT && driver.config().clickViaJs() ? ClickMethod.JS : method;
    }

    protected void defaultClick(Driver driver, WebElement element, int offsetX, int offsetY, List<Keys> holdingKeys) {
        if (this.isCenter(offsetX, offsetY) && holdingKeys.isEmpty()) {
            element.click();
        } else {
            Actions actions = driver.actions();
            this.holdKeys(actions, holdingKeys);
            actions.moveToElement(element, offsetX, offsetY).click();
            this.releaseKeys(actions, holdingKeys);
            actions.perform();
        }
    }

    protected void holdKeys(Actions actions, List<Keys> keys) {
        for (Keys key : keys) {
            actions.keyDown((CharSequence)key);
        }
    }

    protected void releaseKeys(Actions actions, List<Keys> holdingKeys) {
        for (Keys key : holdingKeys) {
            actions.keyUp((CharSequence)key);
        }
    }

    protected boolean isCenter(int offsetX, int offsetY) {
        return offsetX == 0 && offsetY == 0;
    }

    protected void clickViaJS(Driver driver, WebElement element, int offsetX, int offsetY, List<Keys> holdingKeys) {
        this.jsSource.execute(driver, element, offsetX, offsetY, this.toClickEventOptions(holdingKeys));
    }

    protected Map<String, Boolean> toClickEventOptions(List<Keys> keys) {
        return Map.of("altKey", keys.contains(Keys.ALT) || keys.contains(Keys.LEFT_ALT), "ctrlKey", keys.contains(Keys.CONTROL) || keys.contains(Keys.LEFT_CONTROL), "shiftKey", keys.contains(Keys.SHIFT) || keys.contains(Keys.LEFT_SHIFT), "metaKey", keys.contains(Keys.META));
    }
}

