/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.TextCheck;
import com.codeborne.selenide.WebElementsCondition;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.TextsMismatch;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.ElementCommunicator;
import com.codeborne.selenide.impl.Html;
import com.codeborne.selenide.impl.Plugins;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebElement;

public class ExactTexts
extends WebElementsCondition {
    private static final ElementCommunicator communicator = Plugins.inject(ElementCommunicator.class);
    protected final List<String> expectedTexts;

    public ExactTexts(String ... expectedTexts) {
        this(Arrays.asList(expectedTexts));
    }

    public ExactTexts(List<String> expectedTexts) {
        if (expectedTexts.isEmpty()) {
            throw new IllegalArgumentException("No expected texts given");
        }
        this.expectedTexts = Collections.unmodifiableList(expectedTexts);
    }

    @Override
    public CheckResult check(Driver driver, List<WebElement> elements) {
        List<String> actualTexts = communicator.texts(driver, elements);
        int expectedValuesSize = this.expectedTexts.size();
        int actualValuesSize = actualTexts.size();
        if (actualValuesSize != expectedValuesSize) {
            String message = String.format("List size mismatch (expected: %s, actual: %s)", expectedValuesSize, actualValuesSize);
            return CheckResult.rejected(message, actualTexts);
        }
        for (int i = 0; i < expectedValuesSize; ++i) {
            String expectedText = this.expectedTexts.get(i);
            String actualText = actualTexts.get(i);
            if (this.check(driver.config(), actualText, expectedText)) continue;
            String message = String.format("Text #%s mismatch (expected: \"%s\", actual: \"%s\")", i, expectedText, actualText);
            return CheckResult.rejected(message, actualTexts);
        }
        return CheckResult.accepted();
    }

    protected boolean check(Config config, String actualText, String expectedText) {
        return Html.text.equals(actualText, expectedText);
    }

    protected boolean matches(TextCheck mode, String actual, String expected) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case TextCheck.PARTIAL_TEXT -> Html.text.contains(actual, expected);
            case TextCheck.FULL_TEXT -> Html.text.equals(actual, expected);
        };
    }

    @Override
    public void fail(CollectionSource collection, CheckResult lastCheckResult, @Nullable Exception cause, long timeoutMs) {
        List actualTexts = (List)lastCheckResult.getActualValue();
        if (actualTexts == null || actualTexts.isEmpty()) {
            throw new ElementNotFound(collection, this.toString(), timeoutMs, (Throwable)cause);
        }
        String message = lastCheckResult.getMessageOrElse(() -> "Texts mismatch");
        throw new TextsMismatch(message, collection, this.expectedTexts, actualTexts, this.explanation, timeoutMs, cause);
    }

    @Override
    public String toString() {
        return "Exact texts " + String.valueOf(this.expectedTexts);
    }
}

