/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.CaseSensitivity;
import com.codeborne.selenide.TextCheck;
import com.codeborne.selenide.WhitespaceHandling;
import java.util.Locale;
import java.util.Map;

public record TextMatchOptions(TextCheck textCheck, CaseSensitivity caseSensitivity, WhitespaceHandling whitespaceHandling) {
    public static TextMatchOptions fullText() {
        return new TextMatchOptions(TextCheck.FULL_TEXT, CaseSensitivity.CASE_SENSITIVE, WhitespaceHandling.TRIM_WHITESPACES);
    }

    public static TextMatchOptions partialText() {
        return new TextMatchOptions(TextCheck.PARTIAL_TEXT, CaseSensitivity.CASE_SENSITIVE, WhitespaceHandling.TRIM_WHITESPACES);
    }

    public TextMatchOptions caseInsensitive() {
        return new TextMatchOptions(this.textCheck, CaseSensitivity.CASE_INSENSITIVE, this.whitespaceHandling);
    }

    public TextMatchOptions caseSensitive() {
        return new TextMatchOptions(this.textCheck, CaseSensitivity.CASE_SENSITIVE, this.whitespaceHandling);
    }

    public TextMatchOptions preserveWhitespaces() {
        return new TextMatchOptions(this.textCheck, this.caseSensitivity, WhitespaceHandling.PRESERVE_WHITESPACES);
    }

    public TextMatchOptions ignoreWhitespaces() {
        return new TextMatchOptions(this.textCheck, this.caseSensitivity, WhitespaceHandling.IGNORE_WHITESPACES);
    }

    public TextMatchOptions trimWhitespaces() {
        return new TextMatchOptions(this.textCheck, this.caseSensitivity, WhitespaceHandling.TRIM_WHITESPACES);
    }

    public Map<String, String> toMap() {
        return Map.of("textCheck", this.textCheck.name(), "caseSensitivity", this.caseSensitivity.name(), "whitespaceHandling", this.whitespaceHandling.name());
    }

    @Override
    public String toString() {
        return this.whitespaceHandling == WhitespaceHandling.TRIM_WHITESPACES ? "%s, %s".formatted(TextMatchOptions.humanize(this.textCheck), TextMatchOptions.humanize(this.caseSensitivity)) : "%s, %s, %s".formatted(TextMatchOptions.humanize(this.textCheck), TextMatchOptions.humanize(this.caseSensitivity), TextMatchOptions.humanize(this.whitespaceHandling));
    }

    private static String humanize(Enum<?> enumValue) {
        return enumValue.name().toLowerCase(Locale.ROOT).replace('_', ' ');
    }
}

