/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class Stopwatch {
    private final long startTimeNano;
    private final long timeoutNano;

    public Stopwatch(Duration timeout) {
        this(timeout.toMillis());
    }

    public Stopwatch(long timeoutMs) {
        this(timeoutMs, System.nanoTime());
    }

    Stopwatch(long timeoutMs, long startTimeNano) {
        this.startTimeNano = startTimeNano;
        this.timeoutNano = TimeUnit.MILLISECONDS.toNanos(timeoutMs);
    }

    public boolean isTimeoutReached() {
        return this.isTimeoutReached(System.nanoTime());
    }

    public long getElapsedTimeMs() {
        return Duration.ofNanos(System.nanoTime() - this.startTimeNano).toMillis();
    }

    boolean isTimeoutReached(long now) {
        return now - this.startTimeNano > this.timeoutNano;
    }

    public void sleep(long milliseconds) {
        if (this.isTimeoutReached()) {
            return;
        }
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static void sleepAtLeast(long milliseconds) {
        Stopwatch stopwatch = new Stopwatch(milliseconds);
        do {
            stopwatch.sleep(milliseconds);
        } while (!stopwatch.isTimeoutReached());
    }
}

