/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.TextMatchOptions;
import com.codeborne.selenide.impl.SelenideProperties;
import com.codeborne.selenide.selector.ByAttribute;
import com.codeborne.selenide.selector.ByDeepShadowCss;
import com.codeborne.selenide.selector.ByLabel;
import com.codeborne.selenide.selector.ByShadowCss;
import com.codeborne.selenide.selector.ByTagAndText;
import com.codeborne.selenide.selector.ByText;
import com.codeborne.selenide.selector.SearchByAttribute;
import com.codeborne.selenide.selector.SearchByText;
import com.codeborne.selenide.selector.WithTagAndText;
import com.codeborne.selenide.selector.WithText;
import org.openqa.selenium.By;

public class Selectors {
    private static final SelenideProperties properties = new SelenideProperties();
    private static final String DEFAULT_TEST_ID = "data-test-id";

    public static By withText(String elementText) {
        return new WithText(elementText);
    }

    public static By withTagAndText(String tag, String elementText) {
        return new WithTagAndText(tag, elementText);
    }

    public static By withTextCaseInsensitive(String elementText) {
        return new SearchByText(elementText, TextMatchOptions.partialText().caseInsensitive());
    }

    public static By byText(String elementText) {
        return new ByText(elementText);
    }

    public static By byTagAndText(String tag, String elementText) {
        return new ByTagAndText(tag, elementText);
    }

    public static By byTextCaseInsensitive(String elementText) {
        return new SearchByText(elementText, TextMatchOptions.fullText().caseInsensitive());
    }

    public static By byLabel(String elementText) {
        return Selectors.byLabel(elementText, TextMatchOptions.fullText());
    }

    public static By byLabel(String elementText, TextMatchOptions options) {
        return new ByLabel(elementText, options);
    }

    public static By byPlaceholder(String placeholderText) {
        return Selectors.byPlaceholder(placeholderText, TextMatchOptions.fullText());
    }

    public static By byPlaceholder(String placeholderText, TextMatchOptions options) {
        return Selectors.byAttribute("placeholder", placeholderText, options);
    }

    public static By byAttribute(String attributeName, String attributeValue) {
        return new ByAttribute(attributeName, attributeValue);
    }

    public static By byAttribute(String attributeName, String attributeValue, TextMatchOptions options) {
        return new SearchByAttribute(attributeName, attributeValue, options);
    }

    public static By shadowCss(String target, String ... shadowHostsChain) {
        return ByShadowCss.cssSelector(target, shadowHostsChain);
    }

    public static By shadowDeepCss(String target) {
        return new ByDeepShadowCss(target);
    }

    public static By by(String attributeName, String attributeValue) {
        return Selectors.byAttribute(attributeName, attributeValue);
    }

    public static By byTitle(String title) {
        return Selectors.byAttribute("title", title);
    }

    public static By byTitle(String title, TextMatchOptions options) {
        return Selectors.byAttribute("title", title, options);
    }

    public static By byAltText(String title) {
        return Selectors.byAttribute("alt", title);
    }

    public static By byAltText(String title, TextMatchOptions options) {
        return Selectors.byAttribute("alt", title, options);
    }

    public static By byTestId(String testId) {
        return Selectors.byAttribute(properties.getProperty("selenide.test-id.attribute", DEFAULT_TEST_ID), testId);
    }

    public static By byValue(String value) {
        return Selectors.byAttribute("value", value);
    }

    public static By byName(String name) {
        return By.name((String)name);
    }

    public static By byXpath(String xpath) {
        return By.xpath((String)xpath);
    }

    public static By byLinkText(String linkText) {
        return By.linkText((String)linkText);
    }

    public static By byPartialLinkText(String partialLinkText) {
        return By.partialLinkText((String)partialLinkText);
    }

    public static By byId(String id) {
        return By.id((String)id);
    }

    public static By byCssSelector(String css) {
        return By.cssSelector((String)css);
    }

    public static By byClassName(String className) {
        return By.className((String)className);
    }

    public static By byTagName(String tagName) {
        return By.tagName((String)tagName);
    }
}

