/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.files.DownloadedFile;
import com.codeborne.selenide.files.FileFilter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface DownloadsFolder {
    public List<DownloadedFile> files();

    public List<DownloadedFile> filesNewerThan(long var1);

    public void cleanupBeforeDownload();

    public void deleteIfEmpty();

    default public boolean hasFiles(Set<String> extensions, FileFilter excludingFilter) {
        return this.files().stream().anyMatch(file -> extensions.contains(file.extension().toLowerCase(Locale.ROOT)) && excludingFilter.notMatch(file.getFile()));
    }

    default public Map<String, Long> modificationTimes() {
        return this.files().stream().collect(Collectors.toMap(f -> f.getName(), f -> f.lastModifiedTime()));
    }

    default public Optional<Long> lastModificationTime() {
        return this.modificationTimes().values().stream().max(Long::compare);
    }

    default public String filesAsString() {
        return "[" + this.files().stream().map(f -> f.getName()).collect(Collectors.joining(", ")) + "]";
    }

    public String getPath();
}

