/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.files.DownloadedFile;
import com.codeborne.selenide.impl.FileHelper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserDownloadsFolder
implements DownloadsFolder {
    private static final Logger log = LoggerFactory.getLogger(BrowserDownloadsFolder.class);
    private final File folder;

    protected BrowserDownloadsFolder(File folder) {
        this.folder = folder.getAbsoluteFile();
    }

    public File getFolder() {
        return this.folder;
    }

    @Override
    public List<DownloadedFile> files() {
        File[] files = this.folder.listFiles();
        return files == null ? Collections.emptyList() : Arrays.asList(files).stream().filter(File::isFile).map(file -> DownloadedFile.localFile(file)).toList();
    }

    @Override
    public List<DownloadedFile> filesNewerThan(long modifiedAfterTs) {
        return this.files().stream().filter(file -> file.lastModifiedTime() > 0L).filter(file -> file.isFileModifiedLaterThan(modifiedAfterTs)).collect(Collectors.toList());
    }

    public File file(String fileName) {
        return new File(this.folder, fileName).getAbsoluteFile();
    }

    @Override
    public void cleanupBeforeDownload() {
        try {
            if (this.folder.exists()) {
                log.debug("Going to clean folder {} - found files: {}", (Object)this.folder, this.filesIn(this.folder));
                FileUtils.cleanDirectory((File)this.folder);
                log.debug("After clean folder {}: {}", (Object)this.folder, this.filesIn(this.folder));
            } else {
                log.debug("Folder {} doesn't exist. Nothing to clean up.", (Object)this.folder);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to cleanup folder " + this.folder.getAbsolutePath(), e);
        }
    }

    private Collection<String> filesIn(File dir) {
        return FileUtils.listFiles((File)dir, null, (boolean)false).stream().map(f -> f.getName()).collect(Collectors.toList());
    }

    @Override
    public void deleteIfEmpty() {
        FileHelper.deleteFolderIfEmpty(this.folder);
    }

    @Override
    public String getPath() {
        return this.folder.getPath();
    }

    public String toString() {
        return this.folder.getPath();
    }

    public static @Nullable BrowserDownloadsFolder from(@Nullable File folder) {
        return folder == null ? null : new BrowserDownloadsFolder(folder);
    }
}

