/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import com.google.auto.service.AutoService;
import java.net.URI;
import java.util.Optional;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.devtools.CdpEndpointFinder;
import org.openqa.selenium.devtools.CdpInfo;
import org.openqa.selenium.devtools.CdpVersionFinder;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.SeleniumCdpConnection;
import org.openqa.selenium.devtools.noop.NoOpCdpInfo;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.ExecuteMethod;

@AutoService(value={AugmenterProvider.class})
public class DevToolsProvider
implements AugmenterProvider<HasDevTools> {
    public Predicate<Capabilities> isApplicable() {
        return caps -> this.getCdpUrl((Capabilities)caps) != null;
    }

    public Class<HasDevTools> getDescribedInterface() {
        return HasDevTools.class;
    }

    public HasDevTools getImplementation(final Capabilities caps, ExecuteMethod executeMethod) {
        return new HasDevTools(){
            private volatile @Nullable DevTools devTools;
            private final Object lock = new Object();

            public Optional<DevTools> maybeGetDevTools() {
                return Optional.ofNullable(this.devTools);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public DevTools getDevTools() {
                if (this.devTools == null) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.devTools == null) {
                            Object cdpVersion = caps.getCapability("se:cdpVersion");
                            String version = cdpVersion instanceof String ? (String)cdpVersion : caps.getBrowserVersion();
                            CdpInfo info = new CdpVersionFinder().match(version).orElseGet(NoOpCdpInfo::new);
                            this.devTools = SeleniumCdpConnection.create((Capabilities)caps).map(conn -> new DevTools(arg_0 -> ((CdpInfo)info).getDomains(arg_0), conn)).orElseThrow(() -> new DevToolsException("Unable to create DevTools connection"));
                        }
                    }
                }
                return this.devTools;
            }
        };
    }

    private String getCdpUrl(Capabilities caps) {
        Object cdpEnabled = caps.getCapability("se:cdpEnabled");
        if (cdpEnabled != null && !Boolean.parseBoolean(cdpEnabled.toString())) {
            return null;
        }
        Object cdp = caps.getCapability("se:cdp");
        if (cdp instanceof String) {
            return (String)cdp;
        }
        Optional reportedUri = CdpEndpointFinder.getReportedUri((Capabilities)caps);
        return reportedUri.map(URI::toString).orElse(null);
    }
}

